/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.pidster.tomcat.embed.CatalinaBuilder;
import org.pidster.tomcat.embed.TomcatServerBuilder;
import org.pidster.tomcat.embed.TomcatServiceBuilder;
import org.pidster.tomcat.embed.impl.AbstractLifecycleBuilder;
import org.pidster.tomcat.embed.impl.CatalinaBuilderImpl;
import org.pidster.tomcat.embed.impl.InstanceConfigurer;
import org.pidster.tomcat.embed.impl.TomcatServiceBuilderImpl;

public class TomcatServerBuilderImpl
extends AbstractLifecycleBuilder<CatalinaBuilder, TomcatServerBuilder>
implements TomcatServerBuilder {
    private final Server server;
    static final String[] silences = new String[]{"org.apache.coyote.AbstractProtocol", "org.apache.coyote.ajp.AjpNioProtocol", "org.apache.coyote.http11.Http11Protocol", "org.apache.coyote.http11.Http11NioProtocol", "org.apache.catalina.core.ApplicationContext", "org.apache.catalina.core.AprLifecycleListener", "org.apache.catalina.core.StandardService", "org.apache.catalina.core.StandardEngine", "org.apache.catalina.mbeans.GlobalResourcesLifecycleListener", "org.apache.catalina.startup.Catalina", "org.apache.catalina.startup.ContextConfig", "org.apache.tomcat.util.net.NioSelectorPool"};
    private boolean silentLogging = true;
    private boolean enableNaming = false;

    public TomcatServerBuilderImpl(CatalinaBuilderImpl parent, Map<String, String> config) {
        super(parent);
        String className = "org.apache.catalina.core.StandardServer";
        this.server = InstanceConfigurer.instantiate(TomcatServerBuilderImpl.loader(), Server.class, className, config);
        for (String s : silences) {
            Logger.getLogger(s).setLevel(Level.WARNING);
        }
        this.setLifecycle((Lifecycle)this.server);
    }

    @Override
    public TomcatServerBuilder collect(Service child) {
        child.setServer(this.server);
        this.server.addService(child);
        return this;
    }

    @Override
    public CatalinaBuilder parent() {
        File file;
        String catalinaBase;
        if ((this.server.getCatalinaBase() == null || !this.server.getCatalinaBase().exists()) && System.getProperties().containsKey("catalina.base")) {
            catalinaBase = System.getProperty("catalina.base");
            file = new File(catalinaBase);
            this.setCatalinaBase(file);
        }
        if ((this.server.getCatalinaHome() == null || !this.server.getCatalinaHome().exists()) && System.getProperties().containsKey("catalina.home")) {
            catalinaBase = System.getProperty("catalina.home");
            file = new File(catalinaBase);
            if (file.exists()) {
                this.setCatalinaHome(file);
            } else {
                this.setCatalinaHome(this.server.getCatalinaBase());
            }
        }
        for (String s : silences) {
            if (this.silentLogging) {
                Logger.getLogger(s).setLevel(Level.WARNING);
                continue;
            }
            Logger.getLogger(s).setLevel(Level.INFO);
        }
        return (CatalinaBuilder)((CatalinaBuilder)super.parent()).collect(this.server);
    }

    @Override
    public TomcatServerBuilder setSilentLogging(boolean silentLogging) {
        this.silentLogging = silentLogging;
        return this;
    }

    @Override
    public TomcatServerBuilder setCatalinaBase(File catalinaBase) {
        if (catalinaBase == null || !catalinaBase.exists()) {
            throw new IllegalStateException("catalina.base does not exist: " + catalinaBase);
        }
        System.setProperty("catalina.base", catalinaBase.getAbsolutePath());
        this.server.setCatalinaBase(catalinaBase);
        return this;
    }

    @Override
    public TomcatServerBuilder setCatalinaHome(File catalinaHome) {
        if (catalinaHome == null || !catalinaHome.exists()) {
            throw new IllegalStateException("catalina.home does not exist: " + catalinaHome);
        }
        System.setProperty("catalina.home", catalinaHome.getAbsolutePath());
        this.server.setCatalinaBase(catalinaHome);
        return this;
    }

    @Override
    public TomcatServerBuilder enableNaming() {
        return this.setEnableNaming(true);
    }

    @Override
    public TomcatServerBuilder setEnableNaming(boolean enableNaming) {
        this.enableNaming = enableNaming;
        if (enableNaming) {
            this.enableJndi();
        }
        return this;
    }

    @Override
    public TomcatServerBuilder addGlobalResource(ContextResource resource) {
        if (!this.enableNaming) {
            this.enableJndi();
        }
        NamingResourcesImpl globalNamingResources = new NamingResourcesImpl();
        globalNamingResources.setContainer((Object)this.server);
        this.server.setGlobalNamingResources(globalNamingResources);
        return this;
    }

    @Override
    public TomcatServiceBuilder addService() {
        return this.addService("Catalina", null);
    }

    @Override
    public TomcatServiceBuilder addService(String jvmRoute) {
        return this.addService("Catalina", jvmRoute);
    }

    @Override
    public TomcatServiceBuilder addService(String name, String jvmRoute) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("name", name);
        if (jvmRoute != null) {
            config.put("jvmRoute", jvmRoute);
        }
        return new TomcatServiceBuilderImpl(this, name, config);
    }

    private void enableJndi() {
        this.server.addLifecycleListener((LifecycleListener)new NamingContextListener());
        System.setProperty("catalina.useNaming", "true");
        String value = "org.apache.naming";
        String oldValue = System.getProperty("java.naming.factory.url.pkgs");
        if (oldValue != null) {
            value = oldValue.contains(value) ? oldValue : value + ":" + oldValue;
        }
        System.setProperty("java.naming.factory.url.pkgs", value);
        value = System.getProperty("java.naming.factory.initial");
        if (value == null) {
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        }
        this.enableNaming = true;
    }
}

