/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed;

import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.pidster.tomcat.embed.CatalinaBuilder;
import org.pidster.tomcat.embed.TomcatBuilderException;

public class TomcatFactory {
    private final Properties properties = new Properties();

    public TomcatFactory() {
        this.properties.put("catalina.base", System.getProperty("user.dir"));
        this.properties.put("catalina.home", System.getProperty("user.dir"));
    }

    public TomcatFactory(Properties properties) {
        this();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public CatalinaBuilder create() {
        ServiceLoader<CatalinaBuilder> impls = ServiceLoader.load(CatalinaBuilder.class);
        if (!impls.iterator().hasNext()) {
            throw new TomcatBuilderException("No implementation");
        }
        try {
            CatalinaBuilder builder = impls.iterator().next();
            builder.addProperties(this.properties);
            return builder;
        }
        catch (Exception e) {
            throw new TomcatBuilderException(e);
        }
    }
}

