/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.util.IntrospectionUtils;
import org.pidster.tomcat.embed.TomcatComponentException;

public final class InstanceConfigurer {
    private static final Logger LOGGER = Logger.getLogger(InstanceConfigurer.class.getName());

    private InstanceConfigurer() {
    }

    public static <Z> Z newInstance(Class<Z> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new TomcatComponentException(e);
        }
        catch (IllegalAccessException e) {
            throw new TomcatComponentException(e);
        }
    }

    public static <Z> Z instantiate(ClassLoader loader, Class<Z> iface, String implClass, Map<String, String> config) {
        try {
            Class<?> clazz = loader.loadClass(implClass);
            Class<Z> subclass = clazz.asSubclass(iface);
            Z instance = subclass.newInstance();
            LOGGER.log(Level.FINE, "Instantiated class {0}", subclass.getName());
            InstanceConfigurer.configure(instance, config);
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new TomcatComponentException(e);
        }
        catch (InstantiationException e) {
            throw new TomcatComponentException(e);
        }
        catch (IllegalAccessException e) {
            throw new TomcatComponentException(e);
        }
    }

    public static void configure(Object instance, Map<String, String> params) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (params != null) {
            config.putAll(params);
        }
        Set entrySet = config.entrySet();
        for (Map.Entry entry : entrySet) {
            boolean setProperty = IntrospectionUtils.setProperty((Object)instance, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
            LOGGER.log(Level.FINE, "Set field {0} to {1}? {2}", new Object[]{entry.getKey(), entry.getValue(), setProperty});
        }
    }
}

