/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.pidster.tomcat.embed.impl.FilterHolder;
import org.pidster.tomcat.embed.impl.ServletHolder;

public class InternalContainerInitializer
implements ServletContainerInitializer {
    private final Set<String> roleNames = new HashSet<String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private final Set<ServletContextListener> instantiatedListeners = new HashSet<ServletContextListener>();
    private final Set<FilterHolder> filterHolders = new HashSet<FilterHolder>();
    private final Set<ServletHolder> servletHolders = new HashSet<ServletHolder>();

    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        context.declareRoles(this.roleNames.toArray(new String[this.roleNames.size()]));
        Set<String> attrNames = this.attributes.keySet();
        for (String name : attrNames) {
            Object value = this.attributes.get(name);
            context.setAttribute(name, value);
        }
        Set<String> paramNames = this.initParameters.keySet();
        for (String name : paramNames) {
            String value = this.initParameters.get(name);
            context.setInitParameter(name, value);
        }
        for (ServletContextListener listener : this.instantiatedListeners) {
            context.addListener((EventListener)listener);
        }
        for (FilterHolder filterHolder : this.filterHolders) {
            FilterRegistration.Dynamic filterReg = context.addFilter(filterHolder.name(), filterHolder.filter());
            filterReg.setInitParameters(filterHolder.initParameters());
            filterReg.setAsyncSupported(filterHolder.setAsyncSupported());
            if (filterHolder.servletNames().length > 0) {
                filterReg.addMappingForServletNames(filterHolder.dispatcherTypes(), filterHolder.isMatchAfter(), filterHolder.servletNames());
                continue;
            }
            filterReg.addMappingForUrlPatterns(filterHolder.dispatcherTypes(), filterHolder.isMatchAfter(), filterHolder.urlPatterns());
        }
        for (ServletHolder servletHolder : this.servletHolders) {
            ServletRegistration.Dynamic servletReg = context.addServlet(servletHolder.name(), servletHolder.servlet());
            servletReg.setInitParameters(servletHolder.initParameters());
            servletReg.setAsyncSupported(servletHolder.isAsyncSupported());
            servletReg.addMapping(servletHolder.urlPatterns());
            servletReg.setLoadOnStartup(servletHolder.loadOnStartup());
            if (servletHolder.securityElement() == null) continue;
            servletReg.setServletSecurity(servletHolder.securityElement());
        }
        this.roleNames.clear();
        this.attributes.clear();
        this.initParameters.clear();
        this.instantiatedListeners.clear();
        this.filterHolders.clear();
        this.servletHolders.clear();
    }

    public boolean add(ServletContextListener e) {
        return this.instantiatedListeners.add(e);
    }

    public boolean add(FilterHolder e) {
        return this.filterHolders.add(e);
    }

    public boolean add(ServletHolder e) {
        return this.servletHolders.add(e);
    }

    public void setContextAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public void setContextInitParameter(String initParameter, String value) {
        this.initParameters.put(initParameter, value);
    }
}

