/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletSecurityElement;

public final class ServletHolder {
    private final Servlet servlet;
    private final String name;
    private final Map<String, String> initParameters;
    private final boolean asyncSupported;
    private final String[] urlPatterns;
    private final boolean isMatchAfter;
    private final int loadOnStartup;
    private final ServletSecurityElement securityElement;

    public ServletHolder(Servlet servlet, String ... urlPatterns) {
        this(servlet, servlet.getClass().getName(), new HashMap<String, String>(), true, true, 0, urlPatterns);
    }

    public ServletHolder(Servlet servlet, Map<String, String> initParameters, String ... urlPatterns) {
        this(servlet, servlet.getClass().getName(), initParameters, true, true, 0, urlPatterns);
    }

    public ServletHolder(Servlet servlet, String name, Map<String, String> initParameters, String ... urlPatterns) {
        this(servlet, name, initParameters, true, true, 0, urlPatterns);
    }

    public ServletHolder(Servlet servlet, String name, Map<String, String> initParameters, boolean asyncSupported, boolean isMatchAfter, int loadOnStartup, String ... urlPatterns) {
        this(servlet, name, initParameters, asyncSupported, isMatchAfter, loadOnStartup, (ServletSecurityElement)null, urlPatterns);
    }

    public ServletHolder(Servlet servlet, String name, Map<String, String> initParameters, boolean asyncSupported, boolean isMatchAfter, int loadOnStartup, ServletSecurityElement securityElement, String ... urlPatterns) {
        this.servlet = servlet;
        this.name = name;
        this.initParameters = initParameters;
        this.asyncSupported = asyncSupported;
        this.isMatchAfter = isMatchAfter;
        this.loadOnStartup = loadOnStartup;
        this.securityElement = securityElement;
        this.urlPatterns = Arrays.copyOf(urlPatterns, urlPatterns.length);
    }

    public String name() {
        return this.name;
    }

    public Servlet servlet() {
        return this.servlet;
    }

    public Map<String, String> initParameters() {
        return Collections.unmodifiableMap(this.initParameters);
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public String[] urlPatterns() {
        return Arrays.copyOf(this.urlPatterns, this.urlPatterns.length);
    }

    public boolean isMatchAfter() {
        return this.isMatchAfter;
    }

    public int loadOnStartup() {
        return this.loadOnStartup;
    }

    public ServletSecurityElement securityElement() {
        return this.securityElement;
    }
}

