/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.io.File;
import java.net.URL;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContextListener;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.descriptor.web.ApplicationParameter;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.pidster.tomcat.embed.Tomcat;
import org.pidster.tomcat.embed.TomcatApplicationBuilder;
import org.pidster.tomcat.embed.TomcatHostBuilder;
import org.pidster.tomcat.embed.impl.AbstractContainerBuilder;
import org.pidster.tomcat.embed.impl.FilterHolder;
import org.pidster.tomcat.embed.impl.FixContextListener;
import org.pidster.tomcat.embed.impl.InstanceConfigurer;
import org.pidster.tomcat.embed.impl.InternalContainerInitializer;
import org.pidster.tomcat.embed.impl.ServletHolder;
import org.pidster.tomcat.embed.impl.TomcatHostBuilderImpl;

public class TomcatApplicationBuilderImpl
extends AbstractContainerBuilder<TomcatHostBuilder, TomcatApplicationBuilder>
implements TomcatApplicationBuilder {
    private static final Logger LOGGER = Logger.getLogger(TomcatApplicationBuilderImpl.class.getName());
    private final Context context;
    private final InternalContainerInitializer initializer;
    private boolean makeDirs = false;

    public TomcatApplicationBuilderImpl(TomcatHostBuilderImpl parent, Map<String, String> config) {
        super(parent);
        this.context = (Context)InstanceConfigurer.instantiate(TomcatApplicationBuilderImpl.loader(), StandardContext.class, "org.apache.catalina.core.StandardContext", config);
        this.context.addLifecycleListener((LifecycleListener)new FixContextListener());
        StandardManager manager = new StandardManager();
        manager.setSecureRandomAlgorithm("SHA1PRNG");
        manager.setContext(this.context);
        this.context.setManager((Manager)manager);
        this.initializer = new InternalContainerInitializer();
        this.context.addServletContainerInitializer((ServletContainerInitializer)this.initializer, null);
        this.setContainer((Container)this.context);
    }

    @Override
    public TomcatApplicationBuilder collect(Container child) {
        child.setParent((Container)this.context);
        this.context.addChild(child);
        return this;
    }

    @Override
    public TomcatHostBuilder parent() {
        Host host;
        File appBase;
        File docBase;
        TomcatHostBuilder parent = (TomcatHostBuilder)((TomcatHostBuilder)super.parent()).collect(this.context);
        if (this.makeDirs && (docBase = new File(appBase = new File((host = (Host)this.context.getParent()).getAppBase()), this.context.getPath())).mkdirs()) {
            LOGGER.log(Level.WARNING, "mkdirs was 'true' but {0} was not created", docBase);
        }
        return parent;
    }

    @Override
    public TomcatApplicationBuilder withDefaultConfig() {
        ContextConfig contextConfig = new ContextConfig();
        this.context.addLifecycleListener((LifecycleListener)contextConfig);
        return this;
    }

    @Override
    public TomcatApplicationBuilder makeDirs() {
        this.makeDirs = true;
        return this;
    }

    @Override
    public TomcatApplicationBuilder setContextAttribute(String attribute, Object value) {
        this.initializer.setContextAttribute(attribute, value);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setContextInitParameter(String initParameter, String value) {
        this.initializer.setContextInitParameter(initParameter, value);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addServletContainerInitializer(Class<? extends ServletContainerInitializer> listenerClass) {
        return this.addServletContainerInitializer(listenerClass, null);
    }

    @Override
    public TomcatApplicationBuilder addServletContainerInitializer(Class<? extends ServletContainerInitializer> listenerClass, Set<Class<?>> classes) {
        ServletContainerInitializer instance = InstanceConfigurer.newInstance(listenerClass);
        return this.addServletContainerInitializer(instance, classes);
    }

    @Override
    public TomcatApplicationBuilder addServletContainerInitializer(ServletContainerInitializer sci) {
        return this.addServletContainerInitializer(sci, null);
    }

    @Override
    public TomcatApplicationBuilder addServletContainerInitializer(ServletContainerInitializer sci, Set<Class<?>> classes) {
        this.context.addServletContainerInitializer(sci, classes);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addServletContextListener(Class<? extends ServletContextListener> listenerClass) {
        return this.addServletContextListener(listenerClass, Tomcat.EMPTY_MAP);
    }

    @Override
    public TomcatApplicationBuilder addServletContextListener(Class<? extends ServletContextListener> listenerClass, Map<String, String> config) {
        ServletContextListener instance = InstanceConfigurer.newInstance(listenerClass);
        return this.addServletContextListener(instance);
    }

    @Override
    public TomcatApplicationBuilder addServletContextListener(ServletContextListener listener) {
        this.initializer.add(listener);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addServletFilter(Filter filter, String ... urlPatterns) {
        FilterHolder holder = new FilterHolder(filter, urlPatterns);
        this.initializer.add(holder);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addServletFilter(Filter filter, Map<String, String> initParameters, String ... urlPatterns) {
        FilterHolder holder = new FilterHolder(filter, initParameters, urlPatterns);
        this.initializer.add(holder);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addServletFilter(Filter filter, Map<String, String> initParameters, EnumSet<DispatcherType> dispatcherTypes, String ... urlPatterns) {
        FilterHolder holder = new FilterHolder(filter, initParameters, dispatcherTypes, urlPatterns);
        this.initializer.add(holder);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addServletFilter(Class<? extends Filter> filterClass, String ... patterns) {
        return this.addServletFilter(filterClass, Tomcat.EMPTY_MAP, patterns);
    }

    @Override
    public TomcatApplicationBuilder addServletFilter(Class<? extends Filter> filterClass, Map<String, String> initParameters, String ... patterns) {
        Filter instance = InstanceConfigurer.newInstance(filterClass);
        return this.addServletFilter(instance, patterns);
    }

    @Override
    public TomcatApplicationBuilder addServlet(Class<? extends Servlet> servletClass, String ... patterns) {
        return this.addServlet(servletClass.getName(), servletClass, Tomcat.EMPTY_MAP, patterns);
    }

    @Override
    public TomcatApplicationBuilder addServlet(String name, Class<? extends Servlet> servletClass, String ... patterns) {
        return this.addServlet(name, servletClass, Tomcat.EMPTY_MAP, patterns);
    }

    @Override
    public TomcatApplicationBuilder addServlet(Class<? extends Servlet> servletClass, Map<String, String> config, String ... patterns) {
        return this.addServlet(servletClass.getName(), servletClass, config, patterns);
    }

    @Override
    public TomcatApplicationBuilder addServlet(String name, Class<? extends Servlet> servletClass, Map<String, String> config, String ... patterns) {
        Servlet instance = InstanceConfigurer.newInstance(servletClass);
        return this.addServlet(instance, name, config, patterns);
    }

    @Override
    public TomcatApplicationBuilder addServlet(Servlet servlet, Map<String, String> config, String ... patterns) {
        this.initializer.add(new ServletHolder(servlet, config, patterns));
        return this;
    }

    @Override
    public TomcatApplicationBuilder addServlet(Servlet servlet, String servletName, Map<String, String> config, String ... patterns) {
        this.initializer.add(new ServletHolder(servlet, servletName, config, patterns));
        return this;
    }

    @Override
    public TomcatApplicationBuilder setAllowCasualMultipartParsing(boolean allowCasualMultipartParsing) {
        this.context.setAllowCasualMultipartParsing(allowCasualMultipartParsing);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setConfigFile(URL configFile) {
        this.context.setConfigFile(configFile);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSessionManager(Manager sessionManager) {
        sessionManager.setContext(this.context);
        this.context.setManager(sessionManager);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setCookies(boolean cookies) {
        this.context.setCookies(cookies);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setUseHttpOnly(boolean useHttpOnly) {
        this.context.setUseHttpOnly(useHttpOnly);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSessionCookieName(String sessionCookieName) {
        this.context.setSessionCookieName(sessionCookieName);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSessionCookieDomain(String sessionCookieDomain) {
        this.context.setSessionCookieDomain(sessionCookieDomain);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSessionCookiePath(String sessionCookiePath) {
        this.context.setSessionCookiePath(sessionCookiePath);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSessionCookiePathUsesTrailingSlash(boolean sessionCookiePathUsesTrailingSlash) {
        this.context.setSessionCookiePathUsesTrailingSlash(sessionCookiePathUsesTrailingSlash);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setCrossContext(boolean crossContext) {
        this.context.setCrossContext(crossContext);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setDistributable(boolean distributable) {
        this.context.setDistributable(distributable);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setLoginConfig(LoginConfig config) {
        this.context.setLoginConfig(config);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setReloadable(boolean reloadable) {
        this.context.setReloadable(reloadable);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setPrivileged(boolean privileged) {
        this.context.setPrivileged(privileged);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSessionTimeout(int timeout) {
        this.context.setSessionTimeout(timeout);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSwallowAbortedUploads(boolean swallowAbortedUploads) {
        this.context.setSwallowAbortedUploads(swallowAbortedUploads);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSwallowOutput(boolean swallowOutput) {
        this.context.setSwallowOutput(swallowOutput);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setXmlValidation(boolean xmlValidation) {
        this.context.setXmlValidation(xmlValidation);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.context.setXmlNamespaceAware(xmlNamespaceAware);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addApplicationParameter(ApplicationParameter parameter) {
        this.context.addApplicationParameter(parameter);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addConstraint(SecurityConstraint constraint) {
        this.context.addConstraint(constraint);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addErrorPage(ErrorPage errorPage) {
        this.context.addErrorPage(errorPage);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addLocaleEncodingMappingParameter(String locale, String encoding) {
        this.context.addLocaleEncodingMappingParameter(locale, encoding);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addMimeMapping(String extension, String mimeType) {
        this.context.addMimeMapping(extension, mimeType);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addParameter(String name, String value) {
        this.context.addParameter(name, value);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addRoleMapping(String role, String link) {
        this.context.addRoleMapping(role, link);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addSecurityRole(String role) {
        this.context.addSecurityRole(role);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addWatchedResource(String name) {
        this.context.addWatchedResource(name);
        return this;
    }

    @Override
    public TomcatApplicationBuilder addWelcomeFile(String name) {
        this.context.addWelcomeFile(name);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setResourceOnlyServlets(String resourceOnlyServlets) {
        this.context.setResourceOnlyServlets(resourceOnlyServlets);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setEffectiveMajorVersion(int major) {
        this.context.setEffectiveMajorVersion(major);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setEffectiveMinorVersion(int minor) {
        this.context.setEffectiveMinorVersion(minor);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setWebappVersion(String webappVersion) {
        this.context.setWebappVersion(webappVersion);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setDenyUncoveredHttpMethods(boolean denyUncoveredHttpMethods) {
        this.context.setDenyUncoveredHttpMethods(denyUncoveredHttpMethods);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setDocBase(String docBase) {
        this.context.setDocBase(docBase);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.context.setIgnoreAnnotations(ignoreAnnotations);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setJarScanner(JarScanner jarScanner) {
        this.context.setJarScanner(jarScanner);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setLogEffectiveWebXml(boolean logEffectiveWebXml) {
        this.context.setLogEffectiveWebXml(logEffectiveWebXml);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setInstanceManager(InstanceManager instanceManager) {
        this.context.setInstanceManager(instanceManager);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setJspConfigDescriptor(JspConfigDescriptor descriptor) {
        this.context.setJspConfigDescriptor(descriptor);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setLoader(Loader loader) {
        this.context.setLoader(loader);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setResources(WebResourceRoot resources) {
        this.context.setResources(resources);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setFireRequestListenersOnForwards(boolean enable) {
        this.context.setFireRequestListenersOnForwards(enable);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setPreemptiveAuthentication(boolean enable) {
        this.context.setPreemptiveAuthentication(enable);
        return this;
    }

    @Override
    public TomcatApplicationBuilder setSendRedirectBody(boolean enable) {
        this.context.setSendRedirectBody(enable);
        return this;
    }
}

