/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.pidster.tomcat.embed.Tomcat;
import org.pidster.tomcat.embed.TomcatApplicationBuilder;
import org.pidster.tomcat.embed.TomcatBuilderException;
import org.pidster.tomcat.embed.TomcatHostBuilder;
import org.pidster.tomcat.embed.TomcatServiceBuilder;
import org.pidster.tomcat.embed.impl.AbstractContainerBuilder;
import org.pidster.tomcat.embed.impl.InstanceConfigurer;
import org.pidster.tomcat.embed.impl.TomcatApplicationBuilderImpl;
import org.pidster.tomcat.embed.impl.TomcatServiceBuilderImpl;

public class TomcatHostBuilderImpl
extends AbstractContainerBuilder<TomcatServiceBuilder, TomcatHostBuilder>
implements TomcatHostBuilder {
    private final Host host;
    private final Map<String, TomcatApplicationBuilder> applications = new HashMap<String, TomcatApplicationBuilder>();

    protected TomcatHostBuilderImpl(TomcatServiceBuilderImpl parent, Map<String, String> config) {
        super(parent);
        this.host = InstanceConfigurer.instantiate(TomcatHostBuilderImpl.loader(), Host.class, "org.apache.catalina.core.StandardHost", config);
        this.setContainer((Container)this.host);
    }

    @Override
    public TomcatHostBuilder collect(Context child) {
        child.setParent((Container)this.host);
        this.host.addChild((Container)child);
        return this;
    }

    @Override
    public TomcatServiceBuilder parent() {
        return (TomcatServiceBuilder)((TomcatServiceBuilder)super.parent()).collect(this.host);
    }

    @Override
    public TomcatHostBuilder addApplication(String path, String name, String docBase, Map<String, String> config) {
        if (this.applications.containsKey(path)) {
            throw new TomcatBuilderException("Path already exists: " + path);
        }
        HashMap<String, String> aconfig = new HashMap<String, String>();
        if (config != null && !config.isEmpty()) {
            aconfig.putAll(config);
        }
        aconfig.put("path", path);
        aconfig.put("name", name);
        aconfig.put("docBase", docBase);
        TomcatApplicationBuilderImpl applicationBuilder = new TomcatApplicationBuilderImpl(this, aconfig);
        return applicationBuilder.parent();
    }

    @Override
    public TomcatApplicationBuilder createApplication(String name) {
        return this.createApplication(String.format("/%s", name), name, Tomcat.EMPTY_MAP);
    }

    @Override
    public TomcatApplicationBuilder createApplication(String path, String name) {
        return this.createApplication(path, name, Tomcat.EMPTY_MAP);
    }

    @Override
    public TomcatApplicationBuilder createApplication(String path, String name, Map<String, String> config) {
        if (this.applications.containsKey(path)) {
            throw new TomcatBuilderException("Path already exists: " + path);
        }
        HashMap<String, String> aconfig = new HashMap<String, String>();
        if (config != null && !config.isEmpty()) {
            aconfig.putAll(config);
        }
        aconfig.put("path", path);
        aconfig.put("name", name);
        aconfig.put("docBase", name);
        return new TomcatApplicationBuilderImpl(this, aconfig);
    }
}

