/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;
import org.pidster.tomcat.embed.Tomcat;
import org.pidster.tomcat.embed.TomcatServerBuilder;
import org.pidster.tomcat.embed.TomcatServiceBuilder;
import org.pidster.tomcat.embed.impl.AbstractContainerBuilder;
import org.pidster.tomcat.embed.impl.InstanceConfigurer;
import org.pidster.tomcat.embed.impl.TomcatHostBuilderImpl;
import org.pidster.tomcat.embed.impl.TomcatServerBuilderImpl;

public class TomcatServiceBuilderImpl
extends AbstractContainerBuilder<TomcatServerBuilder, TomcatServiceBuilder>
implements TomcatServiceBuilder {
    private final Service service;
    private final Engine engine;
    private final AtomicInteger connectorCount = new AtomicInteger(0);
    private final AtomicInteger executorCount = new AtomicInteger(0);

    protected TomcatServiceBuilderImpl(TomcatServerBuilderImpl parent, String name, Map<String, String> config) {
        super(parent);
        this.service = InstanceConfigurer.instantiate(TomcatServiceBuilderImpl.loader(), Service.class, "org.apache.catalina.core.StandardService", new HashMap<String, String>());
        this.engine = InstanceConfigurer.instantiate(TomcatServiceBuilderImpl.loader(), Engine.class, "org.apache.catalina.core.StandardEngine", config);
        this.engine.setName(name);
        this.service.setName(this.engine.getName());
        this.setContainer((Container)this.engine);
    }

    @Override
    public TomcatServiceBuilder collect(Host child) {
        if (this.engine.getDefaultHost() == null || "".equals(this.engine.getDefaultHost())) {
            this.engine.setDefaultHost(child.getName());
        }
        child.setParent((Container)this.engine);
        this.engine.addChild((Container)child);
        return this;
    }

    @Override
    public TomcatServerBuilder parent() {
        this.engine.setService(this.service);
        this.service.setContainer((Container)this.engine);
        return (TomcatServerBuilder)((TomcatServerBuilder)super.parent()).collect(this.service);
    }

    @Override
    public TomcatServiceBuilder addStandardConnectors() {
        HashMap<String, String> nconfig = new HashMap<String, String>();
        this.addConnector("org.apache.coyote.http11.Http11NioProtocol", 8080, nconfig);
        HashMap<String, String> aconfig = new HashMap<String, String>();
        this.addConnector("org.apache.coyote.ajp.AjpNioProtocol", 8009, aconfig);
        return this;
    }

    @Override
    public TomcatServiceBuilder addBioExecutor(int port, int minSize, int maxSize, Map<String, String> config) {
        String name = String.format("tomcat-embed-exec-%s", this.executorCount.get());
        String prefix = String.format("embed-exec-%s", this.executorCount.get());
        this.addExecutor(name, prefix, minSize, maxSize, config);
        config.put("executorName", name);
        this.addConnector("org.apache.coyote.http11.Http11Protocol", port, config);
        return this;
    }

    @Override
    public TomcatServiceBuilder addNioExecutor(int port, int minSize, int maxSize, Map<String, String> config) {
        String name = String.format("tomcat-embed-exec-%s", this.executorCount.get());
        String prefix = String.format("embed-exec-%s", this.executorCount.get());
        this.addExecutor(name, prefix, minSize, maxSize, config);
        config.put("executorName", name);
        this.addConnector("org.apache.coyote.http11.Http11NioProtocol", port, config);
        return this;
    }

    @Override
    public TomcatServiceBuilder addExecutor(String name, String prefix, int minSize, int maxSize, Map<String, String> config) {
        HashMap<String, String> c = new HashMap<String, String>();
        c.putAll(config);
        c.put("name", name);
        c.put("namePrefix", prefix);
        org.apache.catalina.Executor executor = InstanceConfigurer.instantiate(TomcatServiceBuilderImpl.loader(), org.apache.catalina.Executor.class, "org.apache.catalina.core.StandardThreadExecutor", c);
        this.service.addExecutor(executor);
        this.executorCount.incrementAndGet();
        return this;
    }

    @Override
    public TomcatServiceBuilder addConnector(String protocol, int port) {
        return this.addConnector(protocol, port, Tomcat.EMPTY_MAP);
    }

    @Override
    public TomcatServiceBuilder addConnector(String protocol, int port, Map<String, String> config) {
        org.apache.catalina.Executor executor;
        Connector connector = new Connector(protocol);
        connector.setPort(port);
        Map<Object, Object> internal = new HashMap();
        if (config != null) {
            internal = Collections.unmodifiableMap(config);
        }
        if (this.service.findExecutors().length > 0 && internal.containsKey("executorName") && (executor = this.service.getExecutor((String)internal.get("executorName"))) != null) {
            AbstractProtocol protocolHandler = (AbstractProtocol)connector.getProtocolHandler();
            protocolHandler.setExecutor((Executor)executor);
            Set<Map.Entry<Object, Object>> entrySet = internal.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                protocolHandler.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        InstanceConfigurer.configure(connector, internal);
        Set<Map.Entry<Object, Object>> entrySet = internal.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            connector.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        connector.setService(this.service);
        this.service.addConnector(connector);
        this.connectorCount.incrementAndGet();
        return this;
    }

    @Override
    public TomcatHostBuilderImpl addHost(String name, String appBase) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("name", name);
        config.put("appBase", appBase);
        return new TomcatHostBuilderImpl(this, config);
    }
}

