/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.junit;

import java.io.File;
import javax.servlet.ServletContainerInitializer;
import org.pidster.tomcat.embed.TomcatApplicationBuilder;
import org.pidster.tomcat.embed.TomcatFactory;
import org.pidster.tomcat.embed.junit.TomcatApplicationBuilderFactory;
import org.pidster.tomcat.embed.junit.TomcatServerConfig;

public class SimpleTomcatApplicationBuilderFactory
implements TomcatApplicationBuilderFactory {
    @Override
    public TomcatApplicationBuilder getBuilder(TomcatServerConfig annotation) {
        File appDir;
        String baseDir = annotation.baseDir();
        if ("".equals(baseDir)) {
            baseDir = System.getProperty("user.dir");
        }
        File baseFile = new File(baseDir);
        String appName = annotation.appName();
        if ("".equals(appName)) {
            appName = "test";
        }
        if (!(appDir = new File(baseDir, String.format("webapps/%s", appName))).exists()) {
            appDir.mkdirs();
        }
        TomcatApplicationBuilder builder = ((TomcatApplicationBuilder)new TomcatFactory().create().newMinimalServer(baseFile, annotation.port()).createApplication(annotation.appName()).setStartStopThreads(1)).withDefaultConfig();
        for (Class<? extends ServletContainerInitializer> initializer : annotation.value()) {
            builder.addServletContainerInitializer(initializer);
            System.out.println("annotation.addServletContainerInitializer(" + initializer + ")");
        }
        return builder;
    }
}

