/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.junit;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.pidster.tomcat.embed.Tomcat;
import org.pidster.tomcat.embed.TomcatApplicationBuilder;
import org.pidster.tomcat.embed.TomcatRuntime;
import org.pidster.tomcat.embed.junit.SimpleTomcatApplicationBuilderFactory;
import org.pidster.tomcat.embed.junit.TomcatApplicationBuilderFactory;
import org.pidster.tomcat.embed.junit.TomcatServerConfig;

public class TomcatServerRule
implements TestRule {
    private Class<? extends TomcatApplicationBuilderFactory> factoryClass;
    private TomcatServerConfig annotation;
    private TomcatRuntime runtime;
    private int port;
    private Set<ServletContainerInitializer> initializers = new HashSet<ServletContainerInitializer>();

    public TomcatServerRule() {
        this(SimpleTomcatApplicationBuilderFactory.class);
    }

    public TomcatServerRule(Class<? extends TomcatApplicationBuilderFactory> factoryClass) {
        this.factoryClass = factoryClass;
    }

    public final Statement apply(Statement base, Description description) {
        this.annotation = (TomcatServerConfig)description.getAnnotation(TomcatServerConfig.class);
        return this.statement(base, description);
    }

    private Statement statement(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    TomcatServerRule.this.start();
                    base.evaluate();
                }
                finally {
                    TomcatServerRule.this.stop();
                }
            }
        };
    }

    private void start() throws Exception {
        TomcatApplicationBuilderFactory builderFactory = this.factoryClass.newInstance();
        TomcatApplicationBuilder builder = builderFactory.getBuilder(this.annotation);
        System.out.println("before.addServletContainerInitializer()");
        for (ServletContainerInitializer initializer : this.initializers) {
            builder.addServletContainerInitializer(initializer);
            System.out.println("builder.addServletContainerInitializer(" + initializer + ")");
        }
        System.out.println("after.addServletContainerInitializer()");
        this.port = this.annotation.port();
        Tomcat tomcat = (Tomcat)builder.build();
        this.runtime = tomcat.start(this.annotation.timeout());
    }

    private void stop() {
        this.runtime.stop(this.annotation.timeout());
    }

    public final TomcatRuntime deploy(String appName) {
        return this.runtime.deploy(appName);
    }

    public final TomcatRuntime undeploy(String appName) {
        return this.runtime.undeploy(appName);
    }

    public final int getPort() {
        return this.port;
    }
}

