/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.junit;

import java.io.File;
import javax.servlet.ServletContainerInitializer;
import org.pidster.tomcat.embed.TomcatApplicationBuilder;
import org.pidster.tomcat.embed.TomcatFactory;
import org.pidster.tomcat.embed.junit.TomcatApplicationBuilderFactory;
import org.pidster.tomcat.embed.junit.TomcatServerConfig;

public class SimpleTomcatApplicationBuilderFactory
implements TomcatApplicationBuilderFactory {
    @Override
    public TomcatApplicationBuilder getBuilder(TomcatServerConfig annotation) {
        File baseFile = this.getBaseDir(annotation);
        String appName = this.getAppName(annotation);
        int port = this.getPort(annotation);
        File appDir = new File(baseFile, String.format("webapps/%s", appName));
        if (!appDir.exists() && !appDir.mkdirs()) {
            throw new IllegalStateException("Unable to create app dir at: " + appDir);
        }
        TomcatApplicationBuilder builder = ((TomcatApplicationBuilder)new TomcatFactory().create().newMinimalServer(baseFile, port).createApplication(appName).setStartStopThreads(1)).withDefaultConfig();
        if (annotation != null) {
            for (Class<? extends ServletContainerInitializer> initializer : annotation.value()) {
                builder.addServletContainerInitializer(initializer);
            }
        }
        return builder;
    }

    private int getPort(TomcatServerConfig annotation) {
        int port = annotation == null ? 48080 : annotation.port();
        return port;
    }

    private String getAppName(TomcatServerConfig annotation) {
        String appName = annotation == null || "".equals(annotation.appName()) ? "test" : annotation.appName();
        return appName;
    }

    private File getBaseDir(TomcatServerConfig annotation) {
        String baseDir = annotation == null || "".equals(annotation.baseDir()) ? (System.getProperties().containsKey("catalina.home") ? System.getProperty("catalina.home") : System.getProperty("user.dir") + File.separator + "build") : annotation.baseDir();
        return new File(baseDir);
    }
}

