/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.tomcat.embed.junit;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.pidster.tomcat.embed.Tomcat;
import org.pidster.tomcat.embed.TomcatApplicationBuilder;
import org.pidster.tomcat.embed.TomcatRuntime;
import org.pidster.tomcat.embed.junit.SimpleTomcatApplicationBuilderFactory;
import org.pidster.tomcat.embed.junit.TomcatApplicationBuilderFactory;
import org.pidster.tomcat.embed.junit.TomcatServerConfig;

public class TomcatServerRule
implements TestRule {
    private Class<? extends TomcatApplicationBuilderFactory> factoryClass;
    private TomcatServerConfig annotation;
    private TomcatRuntime runtime;
    private long timeout;
    private Set<ServletContainerInitializer> initializers = new HashSet<ServletContainerInitializer>();

    public TomcatServerRule() {
        this(SimpleTomcatApplicationBuilderFactory.class);
    }

    public TomcatServerRule(Class<? extends TomcatApplicationBuilderFactory> factoryClass) {
        this.factoryClass = factoryClass;
    }

    public final Statement apply(final Statement base, Description description) {
        this.annotation = (TomcatServerConfig)description.getAnnotation(TomcatServerConfig.class);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    TomcatServerRule.this.start();
                    base.evaluate();
                }
                finally {
                    TomcatServerRule.this.stop();
                }
            }
        };
    }

    private void start() throws InstantiationException, IllegalAccessException {
        TomcatApplicationBuilderFactory builderFactory = this.factoryClass.newInstance();
        TomcatApplicationBuilder builder = builderFactory.getBuilder(this.annotation);
        for (ServletContainerInitializer initializer : this.initializers) {
            builder.addServletContainerInitializer(initializer);
        }
        this.timeout = this.annotation != null ? this.annotation.timeout() : 1000L;
        Tomcat tomcat = (Tomcat)builder.build();
        this.runtime = tomcat.start(this.timeout);
    }

    private void stop() {
        if (this.runtime != null) {
            this.runtime.stop(this.timeout);
        }
    }

    public TomcatServerRule addInitializer(ServletContainerInitializer initializer) {
        if (this.runtime != null) {
            throw new IllegalStateException("Can't add a ServletContainerInitializer after start has been called");
        }
        this.initializers.add(initializer);
        return this;
    }

    public TomcatServerRule deploy(String appName) {
        this.runtime.deploy(appName);
        return this;
    }

    public TomcatServerRule undeploy(String appName) {
        this.runtime.undeploy(appName);
        return this;
    }

    public int getPort() {
        try {
            Service service = this.runtime.getServer().findServices()[0];
            Connector connector = service.findConnectors()[0];
            AbstractProtocol abstractProtocol = (AbstractProtocol)connector.getProtocolHandler();
            return abstractProtocol.getLocalPort();
        }
        catch (Exception e) {
            throw new IllegalStateException("Listening port value was not retrievable", e);
        }
    }
}

