/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.util.jmx;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.pidster.util.jmx.ClientException;
import org.pidster.util.jmx.Closer;
import org.pidster.util.jmx.JMXServiceURLs;

public class JMXConnectorClients {
    private static final String JMX_REMOTE_CREDENTIALS = "jmx.remote.credentials";
    private static final String LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String MANAGEMENT_AGENT_JAR_FORMAT = "%1$s%2$slib%2$smanagement-agent.jar";

    public static JMXConnector attach(String pid) {
        VirtualMachine machine = null;
        try {
            machine = VirtualMachine.attach(pid);
            String javaHome = System.getProperty("java.home");
            if (!machine.getAgentProperties().contains(LOCAL_CONNECTOR_ADDRESS)) {
                String agent = String.format(MANAGEMENT_AGENT_JAR_FORMAT, javaHome, File.separator);
                File agentFile = new File(agent);
                if (agentFile == null || !agentFile.exists()) {
                    throw new ClientException("Agent JAR not found: " + agentFile.getAbsolutePath());
                }
                try {
                    machine.loadAgent(agent);
                }
                catch (AgentLoadException e) {
                    throw new ClientException(e);
                }
                catch (AgentInitializationException e) {
                    throw new ClientException(e);
                }
            }
            String serviceURL = machine.getAgentProperties().getProperty(LOCAL_CONNECTOR_ADDRESS);
            JMXConnector jMXConnector = JMXConnectorClients.connect(serviceURL);
            return jMXConnector;
        }
        catch (AttachNotSupportedException e) {
            throw new ClientException(e);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
        finally {
            Closer.detach(machine);
        }
    }

    public static JMXConnector connect(String url) {
        try {
            JMXServiceURL serviceURL = JMXServiceURLs.serviceURL(url);
            return JMXConnectorFactory.connect(serviceURL, null);
        }
        catch (MalformedURLException e) {
            throw new ClientException(e);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    public static JMXConnector connect(String hostname, int port) {
        try {
            JMXServiceURL serviceURL = JMXServiceURLs.serviceURL(hostname, port);
            return JMXConnectorFactory.connect(serviceURL, null);
        }
        catch (MalformedURLException e) {
            throw new ClientException(e);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    public static JMXConnector connect(String hostname, int port, String username, String password) {
        try {
            JMXServiceURL serviceURL = JMXServiceURLs.serviceURL(hostname, port);
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] credentials = new String[]{username, password};
            env.put(JMX_REMOTE_CREDENTIALS, credentials);
            JMXConnector connector = JMXConnectorFactory.newJMXConnector(serviceURL, env);
            connector.connect(env);
            return connector;
        }
        catch (MalformedURLException e) {
            throw new ClientException(e);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    public static JMXConnector connect(String hostname, int port, String path, String username, String password) {
        try {
            JMXServiceURL serviceURL = JMXServiceURLs.serviceURL(hostname, port, path);
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] credentials = new String[]{username, password};
            env.put(JMX_REMOTE_CREDENTIALS, credentials);
            JMXConnector connector = JMXConnectorFactory.newJMXConnector(serviceURL, env);
            connector.connect(env);
            return connector;
        }
        catch (MalformedURLException e) {
            throw new ClientException(e);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }
}

