/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.util.jmx;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.pidster.util.jmx.JMXServiceURLs;
import org.pidster.util.jmx.ServerException;

public class JMXConnectorServers {
    public static JMXConnectorServer startServer(String hostname, int port) {
        try {
            JMXServiceURL serviceURL = JMXServiceURLs.serviceURL(hostname, port);
            return JMXConnectorServers.startServer(serviceURL, new HashMap<String, Object>());
        }
        catch (MalformedURLException e) {
            throw new ServerException(e);
        }
    }

    public static JMXConnectorServer startServer(String hostname, int port, File passwordFile, File accessFile) {
        try {
            JMXServiceURL serviceURL = JMXServiceURLs.serviceURL(hostname, port);
            if (passwordFile == null || !passwordFile.exists()) {
                throw new ServerException("Password file is null or missing: " + passwordFile.getAbsolutePath());
            }
            if (accessFile == null || !accessFile.exists()) {
                throw new ServerException("Access file is null or missing: " + accessFile.getAbsolutePath());
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("jmx.remote.x.password.file", passwordFile.getAbsolutePath());
            attributes.put("jmx.remote.x.access.file", accessFile.getAbsolutePath());
            return JMXConnectorServers.startServer(serviceURL, attributes);
        }
        catch (MalformedURLException e) {
            throw new ServerException(e);
        }
    }

    public static JMXConnectorServer startServer(String hostname, int port, File ldapConfig, String ldapConfigEntry) {
        try {
            JMXServiceURL serviceURL = JMXServiceURLs.serviceURL(hostname, port);
            if (ldapConfig == null || !ldapConfig.exists()) {
                throw new ServerException("LDAP config file is null or missing: " + ldapConfig.getAbsolutePath());
            }
            System.setProperty("java.security.auth.login.config", ldapConfig.getAbsolutePath());
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("jmx.remote.x.login.config", ldapConfigEntry);
            return JMXConnectorServers.startServer(serviceURL, attributes);
        }
        catch (MalformedURLException e) {
            throw new ServerException(e);
        }
    }

    public static JMXConnectorServer startServer(JMXServiceURL serviceURL, Map<String, Object> attributes) {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, attributes, mbeanServer);
            connectorServer.start();
            return connectorServer;
        }
        catch (IOException e) {
            throw new ServerException(e);
        }
    }
}

