/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.util.jmx;

import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.pidster.util.jmx.Closer;
import org.pidster.util.jmx.GarbageCollectorMXBeanHandler;
import org.pidster.util.jmx.MemoryMXBeanHandler;
import org.pidster.util.jmx.MemoryPoolMXBeanHandler;
import org.pidster.util.jmx.ProxyException;
import org.pidster.util.jmx.QueryException;
import org.pidster.util.jmx.UnlikelyRuntimeException;

public class JMXProxy {
    private final JMXConnector connector;

    public JMXProxy(JMXConnector connector) {
        this.connector = connector;
    }

    public void close() {
        Closer.close(this.connector);
    }

    protected String getConnectionId() {
        try {
            return this.connector.getConnectionId();
        }
        catch (IOException e) {
            throw new UnlikelyRuntimeException(e);
        }
    }

    protected MBeanServerConnection getConnection() throws IOException {
        return this.connector.getMBeanServerConnection();
    }

    protected Set<ObjectName> queryNames(String domain, String key, String value) {
        try {
            ObjectName name = ObjectName.getInstance(domain, key, value);
            return this.getConnection().queryNames(name, null);
        }
        catch (MalformedObjectNameException e) {
            throw new QueryException(e);
        }
        catch (NullPointerException e) {
            throw new QueryException(e);
        }
        catch (IOException e) {
            throw new QueryException(e);
        }
    }

    protected Set<ObjectName> queryNames(String query) {
        try {
            ObjectName name = new ObjectName(query);
            return this.getConnection().queryNames(name, null);
        }
        catch (MalformedObjectNameException e) {
            throw new QueryException(e);
        }
        catch (NullPointerException e) {
            throw new QueryException(e);
        }
        catch (IOException e) {
            throw new QueryException(e);
        }
    }

    public <B> B getBean(String name, Class<B> beanClass) {
        return this.getBean(name, beanClass, false);
    }

    public <B> B getBean(String name, Class<B> beanClass, boolean notificationBroadcaster) {
        try {
            ObjectName on = new ObjectName(name);
            return this.getBean(on, beanClass, notificationBroadcaster);
        }
        catch (MalformedObjectNameException e) {
            throw new ProxyException(e);
        }
    }

    public <B> B getBean(ObjectName name, Class<B> beanClass) {
        return this.getBean(name, beanClass, false);
    }

    public <B> B getBean(ObjectName name, Class<B> beanClass, boolean notificationBroadcaster) {
        try {
            if (JMX.isMXBeanInterface(beanClass)) {
                return JMX.newMBeanProxy(this.getConnection(), name, beanClass, notificationBroadcaster);
            }
            return JMX.newMXBeanProxy(this.getConnection(), name, beanClass, notificationBroadcaster);
        }
        catch (NullPointerException e) {
            throw new UnlikelyRuntimeException(e);
        }
        catch (IOException e) {
            throw new ProxyException(e);
        }
    }

    public ClassLoadingMXBean getClassLoadingMXBean() {
        return this.getBean("java.lang:type=ClassLoading", ClassLoadingMXBean.class, true);
    }

    public CompilationMXBean getCompilationMXBean() {
        return this.getBean("java.lang:type=Compilation", CompilationMXBean.class, true);
    }

    public List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        String query = String.format("%s,name=*", "java.lang:type=GarbageCollector");
        Set<ObjectName> names = this.queryNames(query);
        try {
            ArrayList<GarbageCollectorMXBean> beans = new ArrayList<GarbageCollectorMXBean>();
            for (ObjectName on : names) {
                GarbageCollectorMXBeanHandler handler = new GarbageCollectorMXBeanHandler(on, this.getConnection());
                Class[] arr = new Class[]{GarbageCollectorMXBean.class};
                Object instance = Proxy.newProxyInstance(this.getClass().getClassLoader(), arr, (InvocationHandler)handler);
                beans.add((GarbageCollectorMXBean)instance);
            }
            return beans;
        }
        catch (Exception e) {
            throw new UnlikelyRuntimeException(e);
        }
    }

    public List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        String query = String.format("%s,name=*", "java.lang:type=MemoryPool");
        Set<ObjectName> names = this.queryNames(query);
        try {
            ArrayList<MemoryPoolMXBean> beans = new ArrayList<MemoryPoolMXBean>();
            for (ObjectName on : names) {
                MemoryPoolMXBeanHandler handler = new MemoryPoolMXBeanHandler(on, this.getConnection());
                Class[] arr = new Class[]{MemoryPoolMXBean.class};
                Object instance = Proxy.newProxyInstance(this.getClass().getClassLoader(), arr, (InvocationHandler)handler);
                beans.add((MemoryPoolMXBean)instance);
            }
            return beans;
        }
        catch (Exception e) {
            throw new UnlikelyRuntimeException(e);
        }
    }

    public OperatingSystemMXBean getOperatingSystemMXBean() {
        return this.getBean("java.lang:type=OperatingSystem", OperatingSystemMXBean.class, true);
    }

    public MemoryMXBean getMemoryMXBean() {
        try {
            ObjectName name = new ObjectName("java.lang:type=Memory");
            MemoryMXBeanHandler handler = new MemoryMXBeanHandler(name, this.getConnection());
            Class[] arr = new Class[]{MemoryMXBean.class};
            return (MemoryMXBean)Proxy.newProxyInstance(this.getClass().getClassLoader(), arr, (InvocationHandler)handler);
        }
        catch (Exception e) {
            throw new UnlikelyRuntimeException(e);
        }
    }

    public RuntimeMXBean getRuntimeMXBean() {
        return this.getBean("java.lang:type=Runtime", RuntimeMXBean.class, true);
    }

    public ThreadMXBean getThreadMXBean() {
        return this.getBean("java.lang:type=Threading", ThreadMXBean.class, true);
    }
}

