/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.util.jmx;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularDataSupport;
import org.pidster.util.jmx.JSON;

public class MBeanJSON
implements JSON {
    private ObjectName name;
    private MBeanInfo info;
    private AttributeList list;

    public MBeanJSON(ObjectName name, MBeanInfo info, AttributeList list) {
        this.name = name;
        this.info = info;
        this.list = list;
    }

    @Override
    public String toJSON() {
        StringBuilder s = new StringBuilder();
        s.append("{\n");
        s.append("\t\"attributes\":{\n");
        boolean first = true;
        for (Attribute attr : this.list.asList()) {
            if (first) {
                first = false;
            } else {
                s.append(",\n");
            }
            s.append("\t\t\"");
            s.append(attr.getName());
            s.append("\":");
            Object value = attr.getValue();
            if (value == null) {
                s.append(value);
                continue;
            }
            MBeanJSON.append(s, value);
        }
        s.append("\n\t}\n");
        s.append("}");
        return s.toString();
    }

    public String toString() {
        return "MBeanJSON [info=" + this.info + ", list=" + this.list + "]";
    }

    private static void append(StringBuilder s, Object value) {
        if (String.class.equals(value.getClass())) {
            s.append("\"");
            s.append(value);
            s.append("\"");
        } else if (Integer.class.equals(value.getClass())) {
            s.append(value);
        } else if (Long.class.equals(value.getClass())) {
            s.append(value);
        } else if (Boolean.class.equals(value.getClass())) {
            s.append(value);
        } else if (ObjectName.class.equals(value.getClass())) {
            s.append(((ObjectName)value).getCanonicalName());
        } else if (CompositeDataSupport.class.equals(value.getClass())) {
            CompositeDataSupport data = (CompositeDataSupport)value;
            s.append(data);
        } else if (Map.class.equals(value.getClass())) {
            s.append("{");
            Map map = (Map)value;
            Set entrySet = map.entrySet();
            boolean first = true;
            for (Map.Entry e : entrySet) {
                if (first) {
                    first = false;
                } else {
                    s.append(",");
                }
                s.append("\"");
                s.append(e.getKey());
                s.append("\":");
                MBeanJSON.append(s, e.getValue());
            }
            s.append("}");
        } else if (TabularDataSupport.class.equals(value.getClass())) {
            s.append("{");
            TabularDataSupport map = (TabularDataSupport)value;
            Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
            boolean first = true;
            for (Map.Entry<Object, Object> e : entrySet) {
                if (first) {
                    first = false;
                } else {
                    s.append(",");
                }
                s.append("\"");
                s.append(e.getKey());
                s.append("\":");
                MBeanJSON.append(s, e.getValue());
            }
            s.append("}");
        } else if (value.getClass().isArray()) {
            s.append("[");
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                Object o = Array.get(value, i);
                MBeanJSON.append(s, o);
            }
            s.append("]");
        } else {
            s.append(value.getClass());
        }
    }
}

