/*
 * Decompiled with CFR 0.152.
 */
package axle.visualize;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import axle.algebra.Plottable;
import axle.graph.DirectedGraph;
import axle.graph.JungDirectedGraph;
import axle.graph.JungUndirectedGraph;
import axle.graph.UndirectedGraph;
import axle.quanta.Time;
import axle.quanta.UnittedQuantity;
import axle.visualize.AxleFrame;
import axle.visualize.BarChart;
import axle.visualize.BarChartComponent;
import axle.visualize.BarChartGrouped;
import axle.visualize.BarChartGroupedComponent;
import axle.visualize.Fed;
import axle.visualize.FrameRepaintingActor;
import axle.visualize.JungDirectedGraphVisualization;
import axle.visualize.JungDirectedGraphVisualization$;
import axle.visualize.JungUndirectedGraphVisualization;
import axle.visualize.JungUndirectedGraphVisualization$;
import axle.visualize.Plot;
import axle.visualize.PlotComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.Manifest;
import spire.algebra.Eq;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public AxleFrame newFrame(int width, int height) {
        return new AxleFrame(width, height, Color.white, "\u03b1\u03c7\u03bb\u03b5");
    }

    public void show(Component component) {
        Dimension minSize = component.getMinimumSize();
        AxleFrame frame = this.newFrame(minSize.width, minSize.height);
        frame.initialize();
        Component rc = frame.add(component);
        rc.setVisible(true);
        frame.setVisible(true);
    }

    public <T> ActorRef play(Component component, Function1<T, T> refreshFn, UnittedQuantity<Time, Object> interval, ActorSystem system) {
        Dimension minSize = component.getMinimumSize();
        AxleFrame frame = this.newFrame(minSize.width, minSize.height);
        ActorRef feeder = ((Fed)((Object)component)).setFeeder(refreshFn, interval, system);
        system.actorOf(Props$.MODULE$.apply(FrameRepaintingActor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame, ((Fed)((Object)component)).feeder().get()})));
        frame.initialize();
        Component rc = frame.add(component);
        rc.setVisible(true);
        frame.setVisible(true);
        return feeder;
    }

    public <X, Y, D> PlotComponent<X, Y, D> enComponentPlot(Plot<X, Y, D> plot, Plottable<X> evidence$1, Eq<X> evidence$2, Plottable<Y> evidence$3, Eq<Y> evidence$4) {
        return new PlotComponent<X, Y, D>(plot, evidence$1, evidence$2, evidence$3, evidence$4);
    }

    public <S, Y, D> BarChartComponent<S, Y, D> enComponentBarChart(BarChart<S, Y, D> barChart, Plottable<Y> evidence$5, Eq<Y> evidence$6, ClassTag<D> evidence$7) {
        return new BarChartComponent<S, Y, D>(barChart, evidence$5, evidence$6, evidence$7);
    }

    public <G, S, Y, D> BarChartGroupedComponent<G, S, Y, D> enComponentBarChartGrouped(BarChartGrouped<G, S, Y, D> barChart, Plottable<Y> evidence$8, Eq<Y> evidence$9, ClassTag<D> evidence$10) {
        return new BarChartGroupedComponent<G, S, Y, D>(barChart, evidence$8, evidence$9, evidence$10);
    }

    public <VP, EP> Component enComponentUndirectedGraph(UndirectedGraph<VP, EP> ug, Manifest<VP> evidence$11, Eq<VP> evidence$12, Eq<EP> evidence$13) {
        Component component;
        UndirectedGraph<VP, EP> undirectedGraph = ug;
        if (undirectedGraph instanceof JungUndirectedGraph) {
            JungUndirectedGraph jungUndirectedGraph = (JungUndirectedGraph)undirectedGraph;
            component = new JungUndirectedGraphVisualization(JungUndirectedGraphVisualization$.MODULE$.$lessinit$greater$default$1(), JungUndirectedGraphVisualization$.MODULE$.$lessinit$greater$default$2(), JungUndirectedGraphVisualization$.MODULE$.$lessinit$greater$default$3()).component(jungUndirectedGraph);
        } else {
            component = new JungUndirectedGraphVisualization(JungUndirectedGraphVisualization$.MODULE$.$lessinit$greater$default$1(), JungUndirectedGraphVisualization$.MODULE$.$lessinit$greater$default$2(), JungUndirectedGraphVisualization$.MODULE$.$lessinit$greater$default$3()).component(new JungUndirectedGraph(ug.vertexPayloads(), ug.edgeFunction(), evidence$11, evidence$12, evidence$13));
        }
        return component;
    }

    public <VP, EP> Component enComponentDirectedGraph(DirectedGraph<VP, EP> dg, Manifest<VP> evidence$14, Eq<VP> evidence$15, Eq<EP> evidence$16) {
        Component component;
        DirectedGraph<VP, EP> directedGraph = dg;
        if (directedGraph instanceof JungDirectedGraph) {
            JungDirectedGraph jungDirectedGraph = (JungDirectedGraph)directedGraph;
            component = new JungDirectedGraphVisualization(JungDirectedGraphVisualization$.MODULE$.$lessinit$greater$default$1(), JungDirectedGraphVisualization$.MODULE$.$lessinit$greater$default$2(), JungDirectedGraphVisualization$.MODULE$.$lessinit$greater$default$3()).component(jungDirectedGraph);
        } else {
            component = new JungDirectedGraphVisualization(JungDirectedGraphVisualization$.MODULE$.$lessinit$greater$default$1(), JungDirectedGraphVisualization$.MODULE$.$lessinit$greater$default$2(), JungDirectedGraphVisualization$.MODULE$.$lessinit$greater$default$3()).component(new JungDirectedGraph(dg.vertexPayloads(), dg.edgeFunction(), evidence$15, evidence$16));
        }
        return component;
    }

    public void component2file(Component component, String filename, String encoding) {
        Dimension minSize = component.getMinimumSize();
        AxleFrame frame = this.newFrame(minSize.width, minSize.height);
        frame.setUndecorated(true);
        frame.initialize();
        Component rc = frame.add(component);
        frame.setVisible(true);
        BufferedImage img = new BufferedImage(frame.getWidth(), frame.getHeight(), 1);
        Graphics2D g = img.createGraphics();
        frame.paintAll(g);
        ImageIO.write((RenderedImage)img, encoding, new File(filename));
        g.dispose();
    }

    public void png(Component component, String filename) {
        this.component2file(component, filename, "PNG");
    }

    public void jpeg(Component component, String filename) {
        this.component2file(component, filename, "JPEG");
    }

    public void gif(Component component, String filename) {
        this.component2file(component, filename, "gif");
    }

    public void bmp(Component component, String filename) {
        this.component2file(component, filename, "BMP");
    }

    private package$() {
        MODULE$ = this;
    }
}

