/*
 * Decompiled with CFR 0.152.
 */
package axle.matrix;

import axle.algebra.FunctionPair;
import axle.matrix.JblasMatrixModule;
import axle.matrix.JblasMatrixModule$;
import axle.matrix.MatrixModule;
import org.jblas.DoubleMatrix;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class JblasMatrixModule$class {
    public static JblasMatrixModule.Matrix matrix(JblasMatrixModule $this, DoubleMatrix s, FunctionPair evidence$4) {
        return new JblasMatrixModule.Matrix($this, s, evidence$4);
    }

    public static JblasMatrixModule.Matrix matrix(JblasMatrixModule $this, int r, int c, Object values, FunctionPair evidence$5) {
        FunctionPair fp = (FunctionPair)Predef$.MODULE$.implicitly((Object)evidence$5);
        DoubleMatrix jblas = new DoubleMatrix((double[])Predef$.MODULE$.genericArrayOps(values).map((Function1)new Serializable($this, fp){
            public static final long serialVersionUID = 0L;
            private final FunctionPair fp$1;

            public final double apply(T x$5) {
                return BoxesRunTime.unboxToDouble((Object)this.fp$1.backward().apply(x$5));
            }
            {
                this.fp$1 = fp$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        jblas.reshape(r, c);
        return $this.matrix(jblas, evidence$5);
    }

    public static JblasMatrixModule.Matrix matrix(JblasMatrixModule $this, int m, int n, Function0 topleft, Function1 left, Function1 top, Function5 fill, FunctionPair evidence$6) {
        FunctionPair fp = (FunctionPair)Predef$.MODULE$.implicitly((Object)evidence$6);
        DoubleMatrix jblas = DoubleMatrix.zeros((int)m, (int)n);
        jblas.put(0, 0, BoxesRunTime.unboxToDouble((Object)fp.backward().apply(topleft.apply())));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), m).map((Function1)new Serializable($this, fp, jblas, left){
            public static final long serialVersionUID = 0L;
            private final FunctionPair fp$2;
            private final DoubleMatrix jblas$4;
            private final Function1 left$1;

            public final DoubleMatrix apply(int r) {
                return this.jblas$4.put(r, 0, BoxesRunTime.unboxToDouble((Object)this.fp$2.backward().apply(this.left$1.apply((Object)BoxesRunTime.boxToInteger((int)r)))));
            }
            {
                this.fp$2 = fp$2;
                this.jblas$4 = jblas$4;
                this.left$1 = left$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)new Serializable($this, fp, jblas, top){
            public static final long serialVersionUID = 0L;
            private final FunctionPair fp$2;
            private final DoubleMatrix jblas$4;
            private final Function1 top$1;

            public final DoubleMatrix apply(int c) {
                return this.jblas$4.put(0, c, BoxesRunTime.unboxToDouble((Object)this.fp$2.backward().apply(this.top$1.apply((Object)BoxesRunTime.boxToInteger((int)c)))));
            }
            {
                this.fp$2 = fp$2;
                this.jblas$4 = jblas$4;
                this.top$1 = top$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), m).flatMap((Function1)new Serializable($this, fp, jblas, n, fill){
            public static final long serialVersionUID = 0L;
            public final FunctionPair fp$2;
            public final DoubleMatrix jblas$4;
            private final int n$1;
            public final Function5 fill$1;

            public final IndexedSeq<DoubleMatrix> apply(int r) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.n$1).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JblasMatrixModule$.anonfun.matrix.3 $outer;
                    private final int r$2;

                    public final DoubleMatrix apply(int c) {
                        Object diag = this.$outer.fp$2.forward().apply((Object)BoxesRunTime.boxToDouble((double)this.$outer.jblas$4.get(this.r$2 - 1, c - 1)));
                        Object left = this.$outer.fp$2.forward().apply((Object)BoxesRunTime.boxToDouble((double)this.$outer.jblas$4.get(this.r$2, c - 1)));
                        Object right = this.$outer.fp$2.forward().apply((Object)BoxesRunTime.boxToDouble((double)this.$outer.jblas$4.get(this.r$2 - 1, c)));
                        return this.$outer.jblas$4.put(this.r$2, c, BoxesRunTime.unboxToDouble((Object)this.$outer.fp$2.backward().apply(this.$outer.fill$1.apply((Object)BoxesRunTime.boxToInteger((int)this.r$2), (Object)BoxesRunTime.boxToInteger((int)c), diag, left, right))));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$2 = r$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.fp$2 = fp$2;
                this.jblas$4 = jblas$4;
                this.n$1 = n$1;
                this.fill$1 = fill$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return $this.matrix(jblas, evidence$6);
    }

    public static JblasMatrixModule.Matrix matrix(JblasMatrixModule $this, int m, int n, Function2 f, FunctionPair evidence$7) {
        FunctionPair fp = (FunctionPair)Predef$.MODULE$.implicitly((Object)evidence$7);
        DoubleMatrix jblas = DoubleMatrix.zeros((int)m, (int)n);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), m).flatMap((Function1)new Serializable($this, fp, jblas, n, f){
            public static final long serialVersionUID = 0L;
            public final FunctionPair fp$3;
            public final DoubleMatrix jblas$5;
            private final int n$2;
            public final Function2 f$3;

            public final IndexedSeq<DoubleMatrix> apply(int r) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.n$2).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JblasMatrixModule$.anonfun.matrix.4 $outer;
                    private final int r$3;

                    public final DoubleMatrix apply(int c) {
                        return this.$outer.jblas$5.put(this.r$3, c, BoxesRunTime.unboxToDouble((Object)this.$outer.fp$3.backward().apply(this.$outer.f$3.apply((Object)BoxesRunTime.boxToInteger((int)this.r$3), (Object)BoxesRunTime.boxToInteger((int)c)))));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$3 = r$3;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.fp$3 = fp$3;
                this.jblas$5 = jblas$5;
                this.n$2 = n$2;
                this.f$3 = f$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return $this.matrix(jblas, evidence$7);
    }

    public static JblasMatrixModule.Matrix diag(JblasMatrixModule $this, JblasMatrixModule.Matrix row, FunctionPair evidence$8) {
        Predef$.MODULE$.assert(row.isRowVector());
        return $this.matrix(DoubleMatrix.diag((DoubleMatrix)row.jblas()), evidence$8);
    }

    public static JblasMatrixModule.Matrix zeros(JblasMatrixModule $this, int m, int n, FunctionPair evidence$9) {
        return $this.matrix(DoubleMatrix.zeros((int)m, (int)n), evidence$9);
    }

    public static JblasMatrixModule.Matrix ones(JblasMatrixModule $this, int m, int n, FunctionPair evidence$10) {
        return $this.matrix(DoubleMatrix.ones((int)m, (int)n), evidence$10);
    }

    public static JblasMatrixModule.Matrix eye(JblasMatrixModule $this, int n, FunctionPair evidence$11) {
        return $this.matrix(DoubleMatrix.eye((int)n), evidence$11);
    }

    public static JblasMatrixModule.Matrix I(JblasMatrixModule $this, int n, FunctionPair evidence$12) {
        return $this.eye(n, evidence$12);
    }

    public static JblasMatrixModule.Matrix rand(JblasMatrixModule $this, int m, int n, FunctionPair evidence$13) {
        return $this.matrix(DoubleMatrix.rand((int)m, (int)n), evidence$13);
    }

    public static JblasMatrixModule.Matrix randn(JblasMatrixModule $this, int m, int n, FunctionPair evidence$14) {
        return $this.matrix(DoubleMatrix.randn((int)m, (int)n), evidence$14);
    }

    public static JblasMatrixModule.Matrix falses(JblasMatrixModule $this, int m, int n) {
        return $this.matrix(DoubleMatrix.zeros((int)m, (int)n), $this.convertBoolean());
    }

    public static JblasMatrixModule.Matrix trues(JblasMatrixModule $this, int m, int n) {
        return $this.matrix(DoubleMatrix.ones((int)m, (int)n), $this.convertBoolean());
    }

    public static JblasMatrixModule.Matrix median(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        MatrixModule.MatrixLike sorted = m.sortColumns();
        return m.rows() % 2 == 0 ? (JblasMatrixModule.Matrix)((JblasMatrixModule.Matrix)sorted).row(m.rows() / 2 - 1).$plus(((JblasMatrixModule.Matrix)sorted).row(m.rows() / 2)).$div(BoxesRunTime.boxToDouble((double)2.0)) : ((JblasMatrixModule.Matrix)sorted).row(m.rows() / 2);
    }

    public static JblasMatrixModule.Matrix centerRows(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        return m.subColumnVector(m.rowMeans());
    }

    public static JblasMatrixModule.Matrix centerColumns(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        return m.subRowVector(m.columnMeans());
    }

    public static JblasMatrixModule.Matrix rowRange(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        return (JblasMatrixModule.Matrix)m.rowMaxs().$minus(m.rowMins());
    }

    public static JblasMatrixModule.Matrix columnRange(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        return (JblasMatrixModule.Matrix)m.columnMaxs().$minus(m.columnMins());
    }

    public static JblasMatrixModule.Matrix sumsq(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        return m.mulPointwise(m).columnSums();
    }

    public static JblasMatrixModule.Matrix cov(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        return (JblasMatrixModule.Matrix)$this.centerColumns(m).t().$u2A2F($this.centerColumns(m)).$div(BoxesRunTime.boxToDouble((double)m.columns()));
    }

    public static JblasMatrixModule.Matrix std(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        return ((JblasMatrixModule.Matrix)$this.sumsq($this.centerColumns(m)).$div(BoxesRunTime.boxToDouble((double)m.columns()))).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$6) {
                return this.apply$mcDD$sp(x$6);
            }

            public double apply$mcDD$sp(double x$6) {
                return package$.MODULE$.sqrt(x$6);
            }
        }, $this.convertDouble());
    }

    public static JblasMatrixModule.Matrix zscore(JblasMatrixModule $this, JblasMatrixModule.Matrix m) {
        return $this.centerColumns(m).divRowVector($this.std(m));
    }

    public static Tuple2 pca(JblasMatrixModule $this, JblasMatrixModule.Matrix Xnorm, double cutoff) {
        Tuple3<JblasMatrixModule.Matrix<Object>, JblasMatrixModule.Matrix<Object>, JblasMatrixModule.Matrix<Object>> tuple3 = $this.cov(Xnorm).fullSVD();
        if (tuple3 != null) {
            Tuple3 tuple32;
            JblasMatrixModule.Matrix u = (JblasMatrixModule.Matrix)tuple3._1();
            JblasMatrixModule.Matrix s = (JblasMatrixModule.Matrix)tuple3._2();
            JblasMatrixModule.Matrix v = (JblasMatrixModule.Matrix)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)u, (Object)s, (Object)v);
            JblasMatrixModule.Matrix u2 = (JblasMatrixModule.Matrix)tuple33._1();
            JblasMatrixModule.Matrix s2 = (JblasMatrixModule.Matrix)tuple33._2();
            JblasMatrixModule.Matrix v2 = (JblasMatrixModule.Matrix)tuple33._3();
            return new Tuple2((Object)u2, (Object)s2);
        }
        throw new MatchError(tuple3);
    }

    public static double pca$default$2(JblasMatrixModule $this) {
        return 0.95;
    }

    public static int numComponentsForCutoff(JblasMatrixModule $this, JblasMatrixModule.Matrix s, double cutoff) {
        List<Object> eigenValuesSquared = s.map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x * x;
            }
        }, $this.convertDouble()).toList();
        double eigenTotal = BoxesRunTime.unboxToDouble((Object)eigenValuesSquared.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        int numComponents = ((GenSeqLike)((TraversableLike)eigenValuesSquared.map((Function1)new Serializable($this, eigenTotal){
            public static final long serialVersionUID = 0L;
            private final double eigenTotal$1;

            public final double apply(double x$8) {
                return this.apply$mcDD$sp(x$8);
            }

            public double apply$mcDD$sp(double x$8) {
                return x$8 / this.eigenTotal$1;
            }
            {
                this.eigenTotal$1 = eigenTotal$1;
            }
        }, List$.MODULE$.canBuildFrom())).scan((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$9, double x$10) {
                return this.apply$mcDDD$sp(x$9, x$10);
            }

            public double apply$mcDDD$sp(double x$9, double x$10) {
                return x$9 + x$10;
            }
        }, List$.MODULE$.canBuildFrom())).indexWhere((Function1)new Serializable($this, cutoff){
            public static final long serialVersionUID = 0L;
            private final double cutoff$1;

            public final boolean apply(double x) {
                return this.apply$mcZD$sp(x);
            }

            public boolean apply$mcZD$sp(double x) {
                return this.cutoff$1 < x;
            }
            {
                this.cutoff$1 = cutoff$1;
            }
        });
        return numComponents;
    }

    public static void $init$(JblasMatrixModule $this) {
        $this.axle$matrix$JblasMatrixModule$_setter_$convertDouble_$eq(new JblasMatrixModule$.anon.1($this));
        $this.axle$matrix$JblasMatrixModule$_setter_$convertInt_$eq(new JblasMatrixModule$.anon.2($this));
        $this.axle$matrix$JblasMatrixModule$_setter_$convertBoolean_$eq(new JblasMatrixModule$.anon.3($this));
    }
}

