/*
 * Decompiled with CFR 0.152.
 */
package axle.matrix;

import axle.matrix.JblasMatrixFactory;
import axle.matrix.JblasMatrixFactory$;
import axle.package$;
import org.jblas.DoubleMatrix;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Numeric;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

public abstract class JblasMatrixFactory$class {
    public static JblasMatrixFactory.JblasMatrix matrix(JblasMatrixFactory $this, DoubleMatrix s, JblasMatrixFactory.JblasElementAdapter elementAdapter) {
        return new JblasMatrixFactory.JblasMatrixImpl($this, s, elementAdapter);
    }

    public static JblasMatrixFactory.JblasMatrix matrix(JblasMatrixFactory $this, int r2, int c, Object values, JblasMatrixFactory.JblasElementAdapter elementAdapter$1) {
        DoubleMatrix jblas = new DoubleMatrix((double[])Predef$.MODULE$.genericArrayOps(values).map((Function1)new Serializable($this, elementAdapter$1){
            public static final long serialVersionUID;
            private final JblasMatrixFactory.JblasElementAdapter elementAdapter$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(T t) {
                return BoxesRunTime.unboxToDouble((Object)this.elementAdapter$1.fp().backward().apply(t));
            }
            {
                this.elementAdapter$1 = jblasElementAdapter;
            }
        }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Double())));
        jblas.reshape(r2, c);
        return $this.matrix(jblas, elementAdapter$1);
    }

    public static JblasMatrixFactory.JblasMatrix matrix(JblasMatrixFactory $this, int m, int n$1, Function0 topleft, Function1 left$1, Function1 top$1, Function5 fill$1, JblasMatrixFactory.JblasElementAdapter elementAdapter$2) {
        DoubleMatrix jblas$4 = DoubleMatrix.zeros((int)m, (int)n$1);
        jblas$4.put(0, 0, BoxesRunTime.unboxToDouble((Object)elementAdapter$2.fp().backward().apply(topleft.apply())));
        Predef$.MODULE$.intWrapper(0).until(m).map((Function1)new Serializable($this, left$1, elementAdapter$2, jblas$4){
            public static final long serialVersionUID;
            private final Function1 left$1;
            private final JblasMatrixFactory.JblasElementAdapter elementAdapter$2;
            private final DoubleMatrix jblas$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final DoubleMatrix apply(int r2) {
                return this.jblas$4.put(r2, 0, BoxesRunTime.unboxToDouble((Object)this.elementAdapter$2.fp().backward().apply(this.left$1.apply((Object)BoxesRunTime.boxToInteger((int)r2)))));
            }
            {
                this.left$1 = function1;
                this.elementAdapter$2 = jblasElementAdapter;
                this.jblas$4 = doubleMatrix;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.intWrapper(0).until(n$1).map((Function1)new Serializable($this, top$1, elementAdapter$2, jblas$4){
            public static final long serialVersionUID;
            private final Function1 top$1;
            private final JblasMatrixFactory.JblasElementAdapter elementAdapter$2;
            private final DoubleMatrix jblas$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final DoubleMatrix apply(int c) {
                return this.jblas$4.put(0, c, BoxesRunTime.unboxToDouble((Object)this.elementAdapter$2.fp().backward().apply(this.top$1.apply((Object)BoxesRunTime.boxToInteger((int)c)))));
            }
            {
                this.top$1 = function1;
                this.elementAdapter$2 = jblasElementAdapter;
                this.jblas$4 = doubleMatrix;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.intWrapper(1).until(m).flatMap((Function1)new Serializable($this, n$1, fill$1, elementAdapter$2, jblas$4){
            public static final long serialVersionUID;
            private final int n$1;
            public final Function5 fill$1;
            public final JblasMatrixFactory.JblasElementAdapter elementAdapter$2;
            public final DoubleMatrix jblas$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final IndexedSeq<DoubleMatrix> apply(int r$2) {
                return (IndexedSeq)Predef$.MODULE$.intWrapper(1).until(this.n$1).map((Function1)new Serializable(this, r$2){
                    public static final long serialVersionUID;
                    private final JblasMatrixFactory$.anonfun.matrix.3 $outer;
                    private final int r$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final DoubleMatrix apply(int c) {
                        Object diag = this.$outer.elementAdapter$2.fp().forward().apply((Object)BoxesRunTime.boxToDouble((double)this.$outer.jblas$4.get(this.r$2 - 1, c - 1)));
                        Object left = this.$outer.elementAdapter$2.fp().forward().apply((Object)BoxesRunTime.boxToDouble((double)this.$outer.jblas$4.get(this.r$2, c - 1)));
                        Object right = this.$outer.elementAdapter$2.fp().forward().apply((Object)BoxesRunTime.boxToDouble((double)this.$outer.jblas$4.get(this.r$2 - 1, c)));
                        return this.$outer.jblas$4.put(this.r$2, c, BoxesRunTime.unboxToDouble((Object)this.$outer.elementAdapter$2.fp().backward().apply(this.$outer.fill$1.apply((Object)BoxesRunTime.boxToInteger((int)this.r$2), (Object)BoxesRunTime.boxToInteger((int)c), diag, left, right))));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$2 = n;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.n$1 = n;
                this.fill$1 = function5;
                this.elementAdapter$2 = jblasElementAdapter;
                this.jblas$4 = doubleMatrix;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return $this.matrix(jblas$4, elementAdapter$2);
    }

    public static JblasMatrixFactory.JblasMatrix matrix(JblasMatrixFactory $this, int m, int n$2, Function2 f$1, JblasMatrixFactory.JblasElementAdapter elementAdapter$3) {
        DoubleMatrix jblas$5 = DoubleMatrix.zeros((int)m, (int)n$2);
        Predef$.MODULE$.intWrapper(0).until(m).flatMap((Function1)new Serializable($this, n$2, f$1, elementAdapter$3, jblas$5){
            public static final long serialVersionUID;
            private final int n$2;
            public final Function2 f$1;
            public final JblasMatrixFactory.JblasElementAdapter elementAdapter$3;
            public final DoubleMatrix jblas$5;

            static {
                long l = serialVersionUID = 0L;
            }

            public final IndexedSeq<DoubleMatrix> apply(int r$3) {
                return (IndexedSeq)Predef$.MODULE$.intWrapper(0).until(this.n$2).map((Function1)new Serializable(this, r$3){
                    public static final long serialVersionUID;
                    private final JblasMatrixFactory$.anonfun.matrix.4 $outer;
                    private final int r$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final DoubleMatrix apply(int c) {
                        return this.$outer.jblas$5.put(this.r$3, c, BoxesRunTime.unboxToDouble((Object)this.$outer.elementAdapter$3.fp().backward().apply(this.$outer.f$1.apply((Object)BoxesRunTime.boxToInteger((int)this.r$3), (Object)BoxesRunTime.boxToInteger((int)c)))));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$3 = n;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.n$2 = n;
                this.f$1 = function2;
                this.elementAdapter$3 = jblasElementAdapter;
                this.jblas$5 = doubleMatrix;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return $this.matrix(jblas$5, elementAdapter$3);
    }

    public static JblasMatrixFactory.JblasMatrix diag(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix row2, JblasMatrixFactory.JblasElementAdapter elementAdapter) {
        Predef$.MODULE$.assert(row2.isRowVector());
        return $this.matrix(DoubleMatrix.diag((DoubleMatrix)row2.jblas()), elementAdapter);
    }

    public static JblasMatrixFactory.JblasMatrix zeros(JblasMatrixFactory $this, int m, int n, JblasMatrixFactory.JblasElementAdapter elementAdapter) {
        return $this.matrix(DoubleMatrix.zeros((int)m, (int)n), elementAdapter);
    }

    public static JblasMatrixFactory.JblasMatrix ones(JblasMatrixFactory $this, int m, int n, JblasMatrixFactory.JblasElementAdapter elementAdapter) {
        return $this.matrix(DoubleMatrix.ones((int)m, (int)n), elementAdapter);
    }

    public static JblasMatrixFactory.JblasMatrix eye(JblasMatrixFactory $this, int n, JblasMatrixFactory.JblasElementAdapter elementAdapter) {
        return $this.matrix(DoubleMatrix.eye((int)n), elementAdapter);
    }

    public static JblasMatrixFactory.JblasMatrix I(JblasMatrixFactory $this, int n, JblasMatrixFactory.JblasElementAdapter elementAdapter) {
        return $this.eye(n, elementAdapter);
    }

    public static JblasMatrixFactory.JblasMatrix rand(JblasMatrixFactory $this, int m, int n, JblasMatrixFactory.JblasElementAdapter elementAdapter) {
        return $this.matrix(DoubleMatrix.rand((int)m, (int)n), elementAdapter);
    }

    public static JblasMatrixFactory.JblasMatrix randn(JblasMatrixFactory $this, int m, int n, JblasMatrixFactory.JblasElementAdapter elementAdapter) {
        return $this.matrix(DoubleMatrix.randn((int)m, (int)n), elementAdapter);
    }

    public static JblasMatrixFactory.JblasMatrix falses(JblasMatrixFactory $this, int m, int n) {
        return $this.matrix(DoubleMatrix.zeros((int)m, (int)n), $this.elementAdapterBoolean());
    }

    public static JblasMatrixFactory.JblasMatrix trues(JblasMatrixFactory $this, int m, int n) {
        return $this.matrix(DoubleMatrix.ones((int)m, (int)n), $this.elementAdapterBoolean());
    }

    public static JblasMatrixFactory.JblasMatrix median(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        JblasMatrixFactory.JblasMatrix sorted = m.sortColumns();
        return m.rows() % 2 == 0 ? (JblasMatrixFactory.JblasMatrix)sorted.row(m.rows() / 2 - 1).$plus(sorted.row(m.rows() / 2)).$div(BoxesRunTime.boxToDouble((double)2.0)) : sorted.row(m.rows() / 2);
    }

    public static JblasMatrixFactory.JblasMatrix centerRows(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        return m.subColumnVector(m.rowMeans());
    }

    public static JblasMatrixFactory.JblasMatrix centerColumns(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        return m.subRowVector(m.columnMeans());
    }

    public static JblasMatrixFactory.JblasMatrix rowRange(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        return (JblasMatrixFactory.JblasMatrix)m.rowMaxs().$minus(m.rowMins());
    }

    public static JblasMatrixFactory.JblasMatrix columnRange(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        return (JblasMatrixFactory.JblasMatrix)m.columnMaxs().$minus(m.columnMins());
    }

    public static JblasMatrixFactory.JblasMatrix sumsq(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        return m.mulPointwise(m).columnSums();
    }

    public static JblasMatrixFactory.JblasMatrix cov(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        return (JblasMatrixFactory.JblasMatrix)$this.centerColumns(m).t().$u2A2F($this.centerColumns(m)).$div(BoxesRunTime.boxToDouble((double)m.columns()));
    }

    public static JblasMatrixFactory.JblasMatrix std(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        return ((JblasMatrixFactory.JblasMatrix)$this.sumsq($this.centerColumns(m)).$div(BoxesRunTime.boxToDouble((double)m.columns()))).map(new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(double d) {
                return this.apply$mcDD$sp(d);
            }

            public double apply$mcDD$sp(double v1) {
                return scala.math.package$.MODULE$.sqrt(v1);
            }
        }, $this.elementAdapterDouble());
    }

    public static JblasMatrixFactory.JblasMatrix zscore(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix m) {
        return $this.centerColumns(m).divRowVector($this.std(m));
    }

    public static Tuple2 pca(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix Xnorm, double cutoff) {
        Tuple3<JblasMatrixFactory.JblasMatrix<Object>, JblasMatrixFactory.JblasMatrix<Object>, JblasMatrixFactory.JblasMatrix<Object>> tuple3 = $this.cov(Xnorm).fullSVD();
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            JblasMatrixFactory.JblasMatrix u = (JblasMatrixFactory.JblasMatrix)tuple32._1();
            JblasMatrixFactory.JblasMatrix s = (JblasMatrixFactory.JblasMatrix)tuple32._2();
            JblasMatrixFactory.JblasMatrix v = (JblasMatrixFactory.JblasMatrix)tuple32._3();
            return new Tuple2((Object)u, (Object)s);
        }
        throw new MatchError(tuple3);
    }

    public static double pca$default$2(JblasMatrixFactory $this) {
        return 0.95;
    }

    public static int numComponentsForCutoff(JblasMatrixFactory $this, JblasMatrixFactory.JblasMatrix s, double cutoff$1) {
        List<Object> eigenValuesSquared = s.map(new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(double d) {
                return this.apply$mcDD$sp(d);
            }

            public double apply$mcDD$sp(double v1) {
                return package$.MODULE$.square(v1);
            }
        }, $this.elementAdapterDouble()).toList();
        double eigenTotal$1 = BoxesRunTime.unboxToDouble((Object)eigenValuesSquared.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        int numComponents = ((GenSeqLike)((TraversableLike)eigenValuesSquared.map((Function1)new Serializable($this, eigenTotal$1){
            public static final long serialVersionUID;
            private final double eigenTotal$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(double d) {
                return this.apply$mcDD$sp(d);
            }

            public double apply$mcDD$sp(double v1) {
                return v1 / this.eigenTotal$1;
            }
            {
                this.eigenTotal$1 = d;
            }
        }, List$.MODULE$.canBuildFrom())).scan((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(double d, double d2) {
                return this.apply$mcDDD$sp(d, d2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return v1 + v2;
            }
        }, List$.MODULE$.canBuildFrom())).indexWhere((Function1)new Serializable($this, cutoff$1){
            public static final long serialVersionUID;
            private final double cutoff$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(double d) {
                return this.apply$mcZD$sp(d);
            }

            public boolean apply$mcZD$sp(double v1) {
                return this.cutoff$1 < v1;
            }
            {
                this.cutoff$1 = d;
            }
        });
        return numComponents;
    }

    public static void $init$(JblasMatrixFactory $this) {
        $this.axle$matrix$JblasMatrixFactory$_setter_$double2double_$eq(new JblasMatrixFactory$.anon.3($this));
        $this.axle$matrix$JblasMatrixFactory$_setter_$formatDouble_$eq((Function1)new JblasMatrixFactory$.anonfun.10($this));
        $this.axle$matrix$JblasMatrixFactory$_setter_$elementAdapterDouble_$eq(new JblasMatrixFactory.JblasElementAdapter<Object>($this, $this.double2double(), $this.formatDouble()));
        $this.axle$matrix$JblasMatrixFactory$_setter_$double2int_$eq(new JblasMatrixFactory$.anon.2($this));
        $this.axle$matrix$JblasMatrixFactory$_setter_$formatInt_$eq((Function1)new JblasMatrixFactory$.anonfun.11($this));
        $this.axle$matrix$JblasMatrixFactory$_setter_$elementAdapterInt_$eq(new JblasMatrixFactory.JblasElementAdapter<Object>($this, $this.double2int(), $this.formatInt()));
        $this.axle$matrix$JblasMatrixFactory$_setter_$double2boolean_$eq(new JblasMatrixFactory$.anon.1($this));
        $this.axle$matrix$JblasMatrixFactory$_setter_$formatBoolean_$eq((Function1)new JblasMatrixFactory$.anonfun.13($this));
        $this.axle$matrix$JblasMatrixFactory$_setter_$elementAdapterBoolean_$eq(new JblasMatrixFactory.JblasElementAdapter<Object>($this, $this.double2boolean(), $this.formatBoolean()));
    }
}

