/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api.query;

import java.lang.reflect.Array;
import org.pinus4j.api.query.QueryOpt;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.utils.StringUtils;

public class Condition {
    private String field;
    private Object value;
    private QueryOpt opt;
    private Condition[] orCond;

    private Condition() {
    }

    private Condition(Condition ... conds) {
        this.orCond = conds;
    }

    private Condition(String field, Object value, QueryOpt opt) {
        if (StringUtils.isBlank(field)) {
            throw new IllegalArgumentException("\u6761\u4ef6\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a, condition field=" + field);
        }
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=" + value);
        }
        if (value.getClass().isArray() && Array.getLength(value) == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value\u662f\u6570\u7ec4\u5e76\u4e14\u6570\u7ec4\u957f\u5ea6\u4e3a0");
        }
        this.field = field;
        this.value = SQLBuilder.formatValue(value);
        this.opt = opt;
    }

    public String getSql() {
        StringBuilder SQL2 = new StringBuilder();
        if (this.orCond != null && this.orCond.length > 0) {
            SQL2.append("(");
            for (Condition cond : this.orCond) {
                SQL2.append(cond.getSql()).append(" OR ");
            }
            SQL2.delete(SQL2.lastIndexOf(" OR "), SQL2.length());
            SQL2.append(")");
            return SQL2.toString();
        }
        SQL2.append(this.field).append(" ").append(this.opt.getSymbol()).append(" ");
        switch (this.opt) {
            case IN: {
                SQL2.append("(");
                for (int i = 0; i < Array.getLength(this.value); ++i) {
                    Object val = Array.get(this.value, i);
                    Class<?> clazz = val.getClass();
                    if (clazz == String.class) {
                        SQL2.append("'").append(val).append("'");
                    } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                        if (((Boolean)val).booleanValue()) {
                            SQL2.append("'").append("1").append("'");
                        } else {
                            SQL2.append("'").append("0").append("'");
                        }
                    } else {
                        SQL2.append(val);
                    }
                    SQL2.append(",");
                }
                SQL2.deleteCharAt(SQL2.length() - 1);
                SQL2.append(")");
                break;
            }
            default: {
                Object value = this.value;
                if (value instanceof String) {
                    SQL2.append(value);
                    break;
                }
                if (value instanceof Boolean) {
                    if (((Boolean)value).booleanValue()) {
                        SQL2.append("'").append("1").append("'");
                        break;
                    }
                    SQL2.append("'").append("0").append("'");
                    break;
                }
                SQL2.append(value);
            }
        }
        return SQL2.toString();
    }

    public String toString() {
        return this.getSql();
    }

    public static Condition eq(String field, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.EQ);
        return cond;
    }

    public static Condition noteq(String field, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.NOTEQ);
        return cond;
    }

    public static Condition gt(String field, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.GT);
        return cond;
    }

    public static Condition gte(String field, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.GTE);
        return cond;
    }

    public static Condition lt(String field, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.LT);
        return cond;
    }

    public static Condition lte(String field, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.LTE);
        return cond;
    }

    public static Condition in(String field, Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN);
        return cond;
    }

    public static Condition in(String field, byte[] values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN);
        return cond;
    }

    public static Condition in(String field, int[] values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN);
        return cond;
    }

    public static Condition in(String field, short[] values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN);
        return cond;
    }

    public static Condition in(String field, long[] values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN);
        return cond;
    }

    public static Condition in(String field, float[] values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN);
        return cond;
    }

    public static Condition in(String field, double[] values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN);
        return cond;
    }

    public static Condition in(String field, boolean[] values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN);
        return cond;
    }

    public static Condition like(String field, String value) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.LIKE);
        return cond;
    }

    public static Condition or(Condition ... conds) {
        if (conds == null || conds.length < 2) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, or\u67e5\u8be2\u6761\u4ef6\u6700\u5c11\u4e3a2\u4e2a");
        }
        Condition cond = new Condition(conds);
        return cond;
    }
}

