/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cache.impl;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.impl.AbstractMemCachedCache;
import org.pinus4j.cluster.DB;
import org.pinus4j.utils.ReflectUtil;
import org.pinus4j.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemCachedPrimaryCacheImpl
extends AbstractMemCachedCache
implements IPrimaryCache {
    public static final Logger LOG = LoggerFactory.getLogger(MemCachedPrimaryCacheImpl.class);

    public MemCachedPrimaryCacheImpl(String s, int expire) {
        super(s, expire);
    }

    @Override
    public Collection<SocketAddress> getAvailableServers() {
        if (this.memClient == null) {
            return null;
        }
        return this.memClient.getAvailableServers();
    }

    @Override
    public void setCountGlobal(String clusterName, String tableName, long count) {
        String key = this._buildGlobalCountKey(clusterName, tableName);
        this._setCount(key, count);
    }

    @Override
    public void removeCountGlobal(String clusterName, String tableName) {
        String key = this._buildGlobalCountKey(clusterName, tableName);
        this._removeCount(key);
    }

    @Override
    public long decrCountGlobal(String clusterName, String tableName, int delta) {
        String key = this._buildGlobalCountKey(clusterName, tableName);
        return this._decrCount(key, delta);
    }

    @Override
    public long incrCountGlobal(String clusterName, String tableName, int delta) {
        String key = this._buildGlobalCountKey(clusterName, tableName);
        return this._incrCount(key, delta);
    }

    @Override
    public long getCountGlobal(String clusterName, String tableName) {
        String key = this._buildGlobalCountKey(clusterName, tableName);
        return this._getCount(key);
    }

    @Override
    public void putGlobal(String clusterName, String tableName, Number id, Object data) {
        if (data == null) {
            return;
        }
        String key = this._buildGlobalKey(clusterName, tableName, id);
        this._put(key, data);
    }

    @Override
    public void putGlobal(String clusterName, String tableName, List<? extends Object> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Object object : data) {
            Number id = ReflectUtil.getPkValue(object);
            keys.add(this._buildGlobalKey(clusterName, tableName, id));
        }
        this._put(keys, data);
    }

    @Override
    public void putGlobal(String clusterName, String tableName, Map<Number, ? extends Object> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Object> datas = new ArrayList<Object>();
        for (Map.Entry<Number, ? extends Object> entry : data.entrySet()) {
            keys.add(this._buildGlobalKey(clusterName, tableName, entry.getKey()));
            datas.add(entry.getValue());
        }
        this._put(keys, datas);
    }

    @Override
    public <T> T getGlobal(String clusterName, String tableName, Number id) {
        String key = this._buildGlobalKey(clusterName, tableName, id);
        return this._get(key);
    }

    public List<Object> getGlobal(String clusterName, String tableName, Number[] ids) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Number id : ids) {
            String key = this._buildGlobalKey(clusterName, tableName, id);
            keys.add(key);
        }
        return this._get(keys);
    }

    @Override
    public void removeGlobal(String clusterName, String tableName, Number id) {
        String key = this._buildGlobalKey(clusterName, tableName, id);
        this._remove(key);
    }

    @Override
    public void removeGlobal(String clusterName, String tableName, List<? extends Number> ids) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Number number : ids) {
            keys.add(this._buildGlobalKey(clusterName, tableName, number));
        }
        this._remove(keys);
    }

    @Override
    public void setCount(DB db, long count) {
        String key = this._buildCountKey(db);
        this._setCount(key, count);
    }

    @Override
    public void removeCount(DB db) {
        String key = this._buildCountKey(db);
        this._removeCount(key);
    }

    @Override
    public long decrCount(DB db, long delta) {
        String key = this._buildCountKey(db);
        return this._decrCount(key, delta);
    }

    @Override
    public long incrCount(DB db, long delta) {
        String key = this._buildCountKey(db);
        return this._incrCount(key, delta);
    }

    @Override
    public long getCount(DB db) {
        String key = this._buildCountKey(db);
        return this._getCount(key);
    }

    @Override
    public void put(DB db, Number id, Object data) {
        if (data == null) {
            return;
        }
        String key = this._buildKey(db, id);
        this._put(key, data);
    }

    @Override
    public void put(DB db, Number[] ids, List<? extends Object> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Number id : ids) {
            keys.add(this._buildKey(db, id));
        }
        this._put(keys, data);
    }

    @Override
    public void put(DB db, Map<Number, ? extends Object> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Object> datas = new ArrayList<Object>();
        for (Map.Entry<Number, ? extends Object> entry : data.entrySet()) {
            keys.add(this._buildKey(db, entry.getKey()));
            datas.add(entry.getValue());
        }
        this._put(keys, datas);
    }

    @Override
    public <T> T get(DB db, Number id) {
        String key = this._buildKey(db, id);
        return this._get(key);
    }

    public List<Object> get(DB db, Number ... ids) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Number id : ids) {
            keys.add(this._buildKey(db, id));
        }
        return this._get(keys);
    }

    @Override
    public void remove(DB db, Number id) {
        String key = this._buildKey(db, id);
        this._remove(key);
    }

    @Override
    public void remove(DB db, List<? extends Number> ids) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Number number : ids) {
            keys.add(this._buildKey(db, number));
        }
        this._remove(keys);
    }

    private void _setCount(String key, long count) {
        try {
            this._removeCount(key);
            this.memClient.incr(key, 0, count);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PRIMARY CACHE] - " + key + " set count=" + count);
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
    }

    private void _removeCount(String key) {
        try {
            this.memClient.delete(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PRIMARY CACHE] - delete " + key);
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
    }

    private long _decrCount(String key, long delta) {
        try {
            if (this.memClient.get(key) != null) {
                long count = this.memClient.decr(key, delta);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[PRIMARY CACHE] - decr " + key + " " + delta);
                }
                return count;
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return -1L;
    }

    private long _incrCount(String key, long delta) {
        try {
            if (this.memClient.get(key) != null) {
                long count = this.memClient.incr(key, delta);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[PRIMARY CACHE] - incr " + key + " " + delta);
                }
                return count;
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return -1L;
    }

    private long _getCount(String key) {
        try {
            String count = (String)this.memClient.get(key);
            if (StringUtils.isNotBlank(count)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[PRIMARY CACHE] - get " + key + " " + count);
                }
                return Long.parseLong(count);
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return -1L;
    }

    private void _put(String key, Object data) {
        try {
            OperationFuture rst = this.memClient.set(key, this.expire, data);
            if (!((Boolean)rst.get()).booleanValue()) {
                LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25");
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("[PRIMARY CACHE] - put " + key + " value=" + data);
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
    }

    private void _put(List<String> keys, List<? extends Object> data) {
        try {
            for (int i = 0; i < keys.size(); ++i) {
                this.memClient.set(keys.get(i), this.expire, data.get(i));
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("[PRIMARY CACHE] - put (" + keys.size() + ") to cache " + keys);
        }
    }

    private <T> T _get(String key) {
        try {
            Object obj = this.memClient.get(key);
            if (LOG.isDebugEnabled()) {
                int hit = 0;
                if (obj != null) {
                    hit = 1;
                }
                LOG.debug("[PRIMARY CACHE] - get " + key + " hit=" + hit);
            }
            return (T)obj;
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
            return null;
        }
    }

    private List<Object> _get(List<String> keys) {
        ArrayList<Object> datas = new ArrayList<Object>();
        try {
            Map dataMap = this.memClient.getBulk(keys);
            if (dataMap != null) {
                Object data = null;
                for (String key : keys) {
                    data = dataMap.get(key);
                    if (data == null) continue;
                    datas.add(data);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("[PRIMARY CACHE] - get" + keys + " hits = " + datas.size());
        }
        return datas;
    }

    private void _remove(String key) {
        try {
            this.memClient.delete(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PRIMARY CACHE] - remove " + key);
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
    }

    private void _remove(List<String> keys) {
        try {
            for (String key : keys) {
                this._remove(key);
            }
        }
        catch (Exception e) {
            LOG.warn("\u64cd\u4f5c\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
    }

    private String _buildGlobalCountKey(String clusterName, String tableName) {
        StringBuilder key = new StringBuilder();
        key.append(clusterName).append(".").append(tableName).append(".c");
        return key.toString();
    }

    private String _buildCountKey(DB db) {
        StringBuilder key = new StringBuilder();
        key.append(db.getClusterName()).append(db.getDbName());
        key.append(".");
        key.append(db.getRegionInfo().getStart()).append(db.getRegionInfo().getEnd());
        key.append(".");
        key.append(db.getTableName()).append(db.getTableIndex());
        key.append(".c");
        return key.toString();
    }

    private String _buildGlobalKey(String clusterName, String tableName, Number id) {
        StringBuilder key = new StringBuilder();
        key.append(clusterName).append(".").append(tableName).append(".");
        key.append(id);
        return key.toString();
    }

    private String _buildKey(DB db, Number id) {
        StringBuilder key = new StringBuilder();
        key.append(db.getClusterName()).append(db.getDbName());
        key.append(".");
        key.append(db.getRegionInfo().getStart()).append(db.getRegionInfo().getEnd());
        key.append(".");
        key.append(db.getTableName()).append(db.getTableIndex());
        key.append(".");
        key.append(id);
        return key.toString();
    }

    public MemcachedClient getMemClient() {
        return this.memClient;
    }

    public void setMemClient(MemcachedClient memClient) {
        this.memClient = memClient;
    }
}

