/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cache.impl;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.spy.memcached.MemcachedClient;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cache.impl.AbstractMemCachedCache;
import org.pinus4j.cluster.DB;
import org.pinus4j.utils.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemCachedSecondCacheImpl
extends AbstractMemCachedCache
implements ISecondCache {
    public static final Logger LOG = LoggerFactory.getLogger(MemCachedSecondCacheImpl.class);
    private static final Random r = new Random();

    public MemCachedSecondCacheImpl(String s, int expire) {
        super(s, expire);
    }

    @Override
    public Collection<SocketAddress> getAvailableServers() {
        if (this.memClient == null) {
            return null;
        }
        return this.memClient.getAvailableServers();
    }

    @Override
    public void putGlobal(IQuery query, String clusterName, String tableName, List data) {
        try {
            String versionKey = this._buildGlobalVersion(clusterName, tableName);
            int version = r.nextInt(10000);
            if (!this._exists(versionKey)) {
                this.memClient.incr(versionKey, 0, (long)version);
            } else {
                version = Integer.parseInt((String)this.memClient.get(versionKey));
            }
            String cacheKey = this._buildGlobalCacheKey(query, clusterName, tableName, version);
            this.memClient.set(cacheKey, this.expire, (Object)data);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[SECOND CACHE] - put to cache done, key: " + cacheKey);
            }
        }
        catch (Exception e) {
            LOG.warn("operate second cache failure");
        }
    }

    @Override
    public List getGlobal(IQuery query, String clusterName, String tableName) {
        try {
            String versionKey = this._buildGlobalVersion(clusterName, tableName);
            if (this._exists(versionKey)) {
                int version = Integer.parseInt((String)this.memClient.get(versionKey));
                String cacheKey = this._buildGlobalCacheKey(query, clusterName, tableName, version);
                List data = (List)this.memClient.get(cacheKey);
                if (LOG.isDebugEnabled() && data != null) {
                    LOG.debug("[SECOND CACHE] -  key " + cacheKey + " hit");
                }
                return data;
            }
        }
        catch (Exception e) {
            LOG.warn("operate second cache failure");
        }
        return null;
    }

    @Override
    public void removeGlobal(String clusterName, String tableName) {
        String versionKey = this._buildGlobalVersion(clusterName, tableName);
        if (this._exists(versionKey)) {
            this.memClient.incr(versionKey, 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[SECOND CACHE] - " + versionKey + " clean");
            }
        }
    }

    @Override
    public void put(IQuery query, DB db, List data) {
        try {
            String versionKey = this._buildShardingVersion(db);
            int version = r.nextInt(10000);
            if (!this._exists(versionKey)) {
                this.memClient.incr(versionKey, 0, (long)version);
            } else {
                version = Integer.parseInt((String)this.memClient.get(versionKey));
            }
            String cacheKey = this._buildShardingCacheKey(query, db, version);
            this.memClient.set(cacheKey, this.expire, (Object)data);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[SECOND CACHE] - put to cache done, key: " + cacheKey);
            }
        }
        catch (Exception e) {
            LOG.warn("operate second cache failure");
        }
    }

    @Override
    public List get(IQuery query, DB db) {
        try {
            String versionKey = this._buildShardingVersion(db);
            if (this._exists(versionKey)) {
                int version = Integer.parseInt((String)this.memClient.get(versionKey));
                String cacheKey = this._buildShardingCacheKey(query, db, version);
                List data = (List)this.memClient.get(cacheKey);
                if (LOG.isDebugEnabled() && data != null) {
                    LOG.debug("[SECOND CACHE] -  key " + cacheKey + " hit");
                }
                return data;
            }
        }
        catch (Exception e) {
            LOG.warn("operate second cache failure");
        }
        return null;
    }

    @Override
    public void remove(DB db) {
        String versionKey = this._buildShardingVersion(db);
        if (this._exists(versionKey)) {
            this.memClient.incr(versionKey, 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[SECOND CACHE] - " + versionKey + " clean");
            }
        }
    }

    private boolean _exists(String key) {
        return this.memClient.get(key) != null;
    }

    private String _buildGlobalVersion(String clusterName, String tableName) {
        StringBuilder versionKey = new StringBuilder("sec.version.");
        versionKey.append(clusterName).append(".");
        versionKey.append(tableName);
        return versionKey.toString();
    }

    public String _buildShardingVersion(DB db) {
        StringBuilder versionKey = new StringBuilder("sec.version.");
        versionKey.append(db.getClusterName()).append(db.getDbName());
        versionKey.append(".");
        versionKey.append(db.getRegionInfo().getStart()).append(db.getRegionInfo().getEnd());
        versionKey.append(".");
        versionKey.append(db.getTableName()).append(db.getTableIndex());
        return versionKey.toString();
    }

    private String _buildGlobalCacheKey(IQuery query, String clusterName, String tableName, int version) {
        StringBuilder cacheKey = new StringBuilder("sec.");
        cacheKey.append(clusterName).append(".");
        cacheKey.append(tableName).append(".");
        cacheKey.append(version).append(".");
        cacheKey.append(SecurityUtil.md5(query.getWhereSql()));
        return cacheKey.toString();
    }

    private String _buildShardingCacheKey(IQuery query, DB db, int version) {
        StringBuilder cacheKey = new StringBuilder("sec.");
        cacheKey.append(db.getClusterName()).append(db.getDbName());
        cacheKey.append(".");
        cacheKey.append(db.getRegionInfo().getStart()).append(db.getRegionInfo().getEnd());
        cacheKey.append(".");
        cacheKey.append(db.getTableName()).append(db.getTableIndex());
        cacheKey.append(".");
        cacheKey.append(version).append(".");
        cacheKey.append(SecurityUtil.md5(query.getWhereSql()));
        return cacheKey.toString();
    }

    public MemcachedClient getMemClient() {
        return this.memClient;
    }

    public void setMemClient(MemcachedClient memClient) {
        this.memClient = memClient;
    }
}

