/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.pinus4j.cluster.beans.DBClusterRegionInfo;
import org.pinus4j.datalayer.SQLBuilder;

public class DB {
    private DataSource datasource;
    private String clusterName;
    private String dbName;
    private String tableName;
    private int tableIndex;
    private DBClusterRegionInfo regionInfo;
    private String databaseProductName;
    private String host;
    private String catalog;

    private DB() {
    }

    public static DB valueOf(DataSource ds, String clusterName, String dbName, String tableName, int tableIndex, DBClusterRegionInfo regionInfo) {
        DB db = new DB();
        db.setDatasource(ds);
        db.setClusterName(clusterName);
        db.setDbName(dbName);
        db.setTableName(tableName);
        db.setTableIndex(tableIndex);
        db.setRegionInfo(regionInfo);
        return db;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append(this.databaseProductName);
        info.append(" host=" + this.host);
        info.append(" db=").append(this.catalog);
        info.append(" tableName=").append(this.tableName).append(this.tableIndex);
        info.append(" start=").append(this.regionInfo.getStart()).append(" end=").append(this.regionInfo.getEnd());
        return info.toString();
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        Connection dbConn = null;
        try {
            dbConn = datasource.getConnection();
            DatabaseMetaData dbMeta = dbConn.getMetaData();
            this.databaseProductName = dbMeta.getDatabaseProductName();
            String url = dbMeta.getURL().substring(13);
            this.host = url.substring(0, url.indexOf("/"));
            this.catalog = dbConn.getCatalog();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            SQLBuilder.close(dbConn);
        }
        this.datasource = datasource;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getTableIndex() {
        return this.tableIndex;
    }

    public void setTableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public DBClusterRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public void setRegionInfo(DBClusterRegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
        result = 31 * result + (this.databaseProductName == null ? 0 : this.databaseProductName.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.regionInfo == null ? 0 : this.regionInfo.hashCode());
        result = 31 * result + this.tableIndex;
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DB other = (DB)obj;
        if (this.catalog == null ? other.catalog != null : !this.catalog.equals(other.catalog)) {
            return false;
        }
        if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
            return false;
        }
        if (this.databaseProductName == null ? other.databaseProductName != null : !this.databaseProductName.equals(other.databaseProductName)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.regionInfo == null ? other.regionInfo != null : !this.regionInfo.equals(other.regionInfo)) {
            return false;
        }
        if (this.tableIndex != other.tableIndex) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }
}

