/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.config.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.enums.EnumDbConnectionPoolCatalog;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.beans.AppDBInfo;
import org.pinus4j.cluster.beans.DBClusterInfo;
import org.pinus4j.cluster.beans.DBClusterRegionInfo;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.cluster.beans.EnvDBInfo;
import org.pinus4j.cluster.config.IClusterConfig;
import org.pinus4j.cluster.enums.EnumClusterCatalog;
import org.pinus4j.cluster.enums.HashAlgoEnum;
import org.pinus4j.cluster.router.IClusterRouter;
import org.pinus4j.exceptions.LoadConfigException;
import org.pinus4j.utils.StringUtils;
import org.pinus4j.utils.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlClusterConfigImpl
implements IClusterConfig {
    public static final Logger LOG = LoggerFactory.getLogger(XmlClusterConfigImpl.class);
    private static EnumDbConnectionPoolCatalog enumCpCatalog;
    private static int idGenerateBatch;
    private static HashAlgoEnum hashAlgo;
    private static boolean isCacheEnabled;
    private static Class<IPrimaryCache> primaryCacheClass;
    private static int primaryCacheExpire;
    private static String primaryCacheAddress;
    private static Class<ISecondCache> secondCacheClass;
    private static int secondCacheExpire;
    private static String secondCacheAddress;
    private static Collection<DBClusterInfo> dbClusterInfos;
    private XmlUtil xmlUtil;
    private static String zkUrl;
    private static IClusterConfig instance;

    private XmlClusterConfigImpl() throws LoadConfigException {
        this(null);
    }

    private XmlClusterConfigImpl(String xmlFilePath) throws LoadConfigException {
        this.xmlUtil = StringUtils.isBlank(xmlFilePath) ? XmlUtil.getInstance() : XmlUtil.getInstance(new File(xmlFilePath));
        Node root = this.xmlUtil.getRoot();
        if (root == null) {
            throw new LoadConfigException("can not found root node");
        }
        try {
            this._loadIdGeneratorBatch(root);
            this._loadZkUrl(root);
            this._loadHashAlgo(root);
            this._loadDBClusterInfo(root);
            this._loadCacheInfo(root);
        }
        catch (Exception e) {
            throw new LoadConfigException(e);
        }
    }

    private void _loadIdGeneratorBatch(Node root) throws LoadConfigException {
        Node idGeneratorBatchNode = this.xmlUtil.getFirstChildByName(root, "db.cluster.generateid.batch");
        try {
            idGenerateBatch = Integer.parseInt(idGeneratorBatchNode.getTextContent().trim());
        }
        catch (NumberFormatException e) {
            throw new LoadConfigException(e);
        }
    }

    private void _loadZkUrl(Node root) throws LoadConfigException {
        Node zkUrlNode = this.xmlUtil.getFirstChildByName(root, "db.cluster.zk");
        zkUrl = zkUrlNode.getTextContent().trim();
    }

    private void _loadHashAlgo(Node root) throws LoadConfigException {
        Node hashAlgoNode = this.xmlUtil.getFirstChildByName(root, "db.cluster.hash.algo");
        hashAlgo = HashAlgoEnum.getEnum(hashAlgoNode.getTextContent().trim());
    }

    private Map<String, Object> _loadDbConnectInfo(Node connPoolNode) throws LoadConfigException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NodeList child = connPoolNode.getChildNodes();
        Node currentNode = null;
        for (int i = 0; i < child.getLength(); ++i) {
            currentNode = child.item(i);
            if (currentNode.getNodeName().equals("maxActive")) {
                map.put("maxActive", Integer.parseInt(currentNode.getTextContent().trim()));
            }
            if (currentNode.getNodeName().equals("minIdle")) {
                map.put("minIdle", Integer.parseInt(currentNode.getTextContent().trim()));
            }
            if (currentNode.getNodeName().equals("maxIdle")) {
                map.put("maxIdle", Integer.parseInt(currentNode.getTextContent().trim()));
            }
            if (currentNode.getNodeName().equals("initialSize")) {
                map.put("initialSize", Integer.parseInt(currentNode.getTextContent().trim()));
            }
            if (currentNode.getNodeName().equals("removeAbandoned")) {
                map.put("removeAbandoned", Boolean.valueOf(currentNode.getTextContent().trim()));
            }
            if (currentNode.getNodeName().equals("removeAbandonedTimeout")) {
                map.put("removeAbandonedTimeout", Integer.parseInt(currentNode.getTextContent().trim()));
            }
            if (currentNode.getNodeName().equals("maxWait")) {
                map.put("maxWait", Integer.parseInt(currentNode.getTextContent().trim()));
            }
            if (currentNode.getNodeName().equals("timeBetweenEvictionRunsMillis")) {
                map.put("timeBetweenEvictionRunsMillis", Integer.parseInt(currentNode.getTextContent().trim()));
            }
            if (currentNode.getNodeName().equals("numTestsPerEvictionRun")) {
                map.put("numTestsPerEvictionRun", Integer.parseInt(currentNode.getTextContent().trim()));
            }
            if (!currentNode.getNodeName().equals("minEvictableIdleTimeMillis")) continue;
            map.put("minEvictableIdleTimeMillis", Integer.parseInt(currentNode.getTextContent().trim()));
        }
        return map;
    }

    private long[] _parseCapacity(String clusterName, String regionCapacity) throws LoadConfigException {
        long[] capacity = new long[2];
        String[] strCapacity = regionCapacity.split("\\-");
        if (strCapacity.length != 2) {
            throw new LoadConfigException("\u89e3\u6790\u96c6\u7fa4\u5bb9\u91cf\u9519\u8bef");
        }
        long start = -1L;
        long end = -1L;
        try {
            start = Long.parseLong(strCapacity[0]);
            end = Long.parseLong(strCapacity[1]);
        }
        catch (Exception e) {
            throw new LoadConfigException("\u89e3\u6790\u96c6\u7fa4\u5bb9\u91cf\u9519\u8bef, clusterName=" + clusterName, e);
        }
        if (start < 0L || end < 0L || end <= start) {
            throw new LoadConfigException("\u96c6\u7fa4\u5bb9\u91cf\u53c2\u6570\u6709\u8bef, clusterName=" + clusterName + ", start=" + start + ", end=" + end);
        }
        capacity[0] = start;
        capacity[1] = end;
        return capacity;
    }

    private DBInfo _getDBConnInfo(String clusterName, Node node, EnumDBMasterSlave masterSlave) throws LoadConfigException {
        DBInfo dbConnInfo = null;
        Node root = this.xmlUtil.getRoot();
        if (root == null) {
            throw new LoadConfigException("\u627e\u4e0d\u5230root\u8282\u70b9");
        }
        Node connPoolNode = this.xmlUtil.getFirstChildByName(root, "db-connection-pool");
        if (connPoolNode == null) {
            throw new LoadConfigException("\u627e\u4e0d\u5230db-connection-pool\u8282\u70b9");
        }
        Node cpCatalogNode = connPoolNode.getAttributes().getNamedItem("catalog");
        String cpCatalog = EnumDbConnectionPoolCatalog.APP.getValue();
        if (cpCatalogNode != null) {
            cpCatalog = cpCatalogNode.getTextContent();
        }
        enumCpCatalog = EnumDbConnectionPoolCatalog.getEnum(cpCatalog);
        switch (enumCpCatalog) {
            case ENV: {
                dbConnInfo = new EnvDBInfo();
                dbConnInfo.setClusterName(clusterName);
                dbConnInfo.setMasterSlave(masterSlave);
                String envDsName = node.getTextContent().trim();
                ((EnvDBInfo)dbConnInfo).setEnvDsName(envDsName);
                break;
            }
            case APP: {
                dbConnInfo = new AppDBInfo();
                dbConnInfo.setClusterName(clusterName);
                dbConnInfo.setMasterSlave(masterSlave);
                String username = this.xmlUtil.getFirstChildByName(node, "db.username").getTextContent().trim();
                String password = this.xmlUtil.getFirstChildByName(node, "db.password").getTextContent().trim();
                String url = this.xmlUtil.getFirstChildByName(node, "db.url").getTextContent().trim();
                ((AppDBInfo)dbConnInfo).setUsername(username);
                ((AppDBInfo)dbConnInfo).setPassword(password);
                ((AppDBInfo)dbConnInfo).setUrl(url);
                ((AppDBInfo)dbConnInfo).setConnPoolInfo(this._loadDbConnectInfo(connPoolNode));
                break;
            }
            default: {
                throw new LoadConfigException("catalog attribute of db-connection-pool config error, catalog = " + cpCatalog + " you should be select in \"env\" or \"app\"");
            }
        }
        dbConnInfo.check();
        return dbConnInfo;
    }

    private DBClusterInfo _getDBClusterInfo(String clusterName, Node clusterNode) throws LoadConfigException {
        DBClusterInfo dbClusterInfo = new DBClusterInfo();
        dbClusterInfo.setClusterName(clusterName);
        try {
            String classFullPath = this.xmlUtil.getAttributeValue(clusterNode, "class");
            if (StringUtils.isBlank(classFullPath)) {
                classFullPath = "org.pinus.cluster.route.impl.SimpleHashClusterRouter";
            }
            Class<IClusterRouter> clazz = Class.forName(classFullPath);
            dbClusterInfo.setRouterClass(clazz);
        }
        catch (Exception e) {
            throw new LoadConfigException(e);
        }
        String catalog = this.xmlUtil.getAttributeValue(clusterNode, "catalog");
        dbClusterInfo.setCatalog(EnumClusterCatalog.getEnum(catalog));
        Node global = this.xmlUtil.getFirstChildByName(clusterNode, "global");
        if (global != null) {
            Node masterGlobal = this.xmlUtil.getFirstChildByName(global, "master");
            DBInfo masterGlobalConnection = this._getDBConnInfo(clusterName, masterGlobal, EnumDBMasterSlave.MASTER);
            dbClusterInfo.setMasterGlobalDBInfo(masterGlobalConnection);
            List<Node> slaveGlobalList = this.xmlUtil.getChildByName(global, "slave");
            if (slaveGlobalList != null && !slaveGlobalList.isEmpty()) {
                ArrayList<DBInfo> slaveGlobalConnection = new ArrayList<DBInfo>();
                int slaveIndex = 0;
                for (Node slaveGlobal : slaveGlobalList) {
                    slaveGlobalConnection.add(this._getDBConnInfo(clusterName, slaveGlobal, EnumDBMasterSlave.getSlaveEnum(slaveIndex++)));
                }
                dbClusterInfo.setSlaveGlobalDBInfo(slaveGlobalConnection);
            }
        }
        ArrayList<DBClusterRegionInfo> dbRegions = new ArrayList<DBClusterRegionInfo>();
        List<Node> regionNodeList = this.xmlUtil.getChildByName(clusterNode, "region");
        DBClusterRegionInfo regionInfo = null;
        for (Node regionNode : regionNodeList) {
            regionInfo = new DBClusterRegionInfo();
            String regionCapacity = this.xmlUtil.getAttributeValue(regionNode, "capacity");
            if (regionCapacity == null) {
                throw new LoadConfigException("<region>\u9700\u8981\u914d\u7f6ecapacity\u5c5e\u6027");
            }
            long[] capacity = this._parseCapacity(clusterName, regionCapacity);
            regionInfo.setStart(capacity[0]);
            regionInfo.setEnd(capacity[1]);
            ArrayList<DBInfo> regionMasterConnection = new ArrayList<DBInfo>();
            Node master = this.xmlUtil.getFirstChildByName(regionNode, "master");
            List<Node> shardingNodeList = this.xmlUtil.getChildByName(master, "sharding");
            for (Node shardingNode : shardingNodeList) {
                regionMasterConnection.add(this._getDBConnInfo(clusterName, shardingNode, EnumDBMasterSlave.MASTER));
            }
            regionInfo.setMasterDBInfos(regionMasterConnection);
            ArrayList<List<DBInfo>> regionSlaveConnection = new ArrayList<List<DBInfo>>();
            List<Node> slaveNodeList = this.xmlUtil.getChildByName(regionNode, "slave");
            int slaveIndex = 0;
            for (Node slaveNode : slaveNodeList) {
                shardingNodeList = this.xmlUtil.getChildByName(slaveNode, "sharding");
                ArrayList<DBInfo> slaveConnections = new ArrayList<DBInfo>();
                for (Node shardingNode : shardingNodeList) {
                    slaveConnections.add(this._getDBConnInfo(clusterName, shardingNode, EnumDBMasterSlave.getSlaveEnum(slaveIndex)));
                }
                regionSlaveConnection.add(slaveConnections);
            }
            regionInfo.setSlaveDBInfos(regionSlaveConnection);
            dbRegions.add(regionInfo);
        }
        dbClusterInfo.setDbRegions(dbRegions);
        return dbClusterInfo;
    }

    private void _loadDBClusterInfo(Node root) throws LoadConfigException {
        List<Node> clusterNodeList = this.xmlUtil.getChildByName(root, "cluster");
        for (Node clusterNode : clusterNodeList) {
            String catalog = this.xmlUtil.getAttributeValue(clusterNode, "catalog");
            if (!catalog.equalsIgnoreCase(EnumClusterCatalog.MYSQL.getValue())) continue;
            String name = this.xmlUtil.getAttributeValue(clusterNode, "name");
            dbClusterInfos.add(this._getDBClusterInfo(name, clusterNode));
        }
    }

    private void _loadCacheInfo(Node root) throws LoadConfigException {
        Node dbClusterCacheNode = this.xmlUtil.getFirstChildByName(root, "db.cluster.cache");
        if (dbClusterCacheNode == null) {
            throw new LoadConfigException("can not found node db.cluster.cache");
        }
        try {
            String isCacheEnabled = this.xmlUtil.getAttributeValue(dbClusterCacheNode, "enabled");
            if (StringUtils.isNotBlank(isCacheEnabled)) {
                XmlClusterConfigImpl.isCacheEnabled = Boolean.valueOf(isCacheEnabled);
            }
            if (XmlClusterConfigImpl.isCacheEnabled) {
                Node primaryNode = this.xmlUtil.getFirstChildByName(dbClusterCacheNode, "primary");
                primaryCacheExpire = Integer.parseInt(this.xmlUtil.getAttributeValue(primaryNode, "expire"));
                String classFullPath = this.xmlUtil.getAttributeValue(primaryNode, "class");
                if (StringUtils.isBlank(classFullPath)) {
                    classFullPath = "org.pinus.cache.impl.MemCachedPrimaryCacheImpl";
                }
                primaryCacheClass = Class.forName(classFullPath);
                Node primaryAddressNode = this.xmlUtil.getFirstChildByName(primaryNode, "address");
                primaryCacheAddress = primaryAddressNode.getTextContent().trim();
                Node secondNode = this.xmlUtil.getFirstChildByName(dbClusterCacheNode, "second");
                secondCacheExpire = Integer.parseInt(this.xmlUtil.getAttributeValue(secondNode, "expire"));
                classFullPath = this.xmlUtil.getAttributeValue(secondNode, "class");
                if (StringUtils.isBlank(classFullPath)) {
                    classFullPath = "org.pinus.cache.impl.MemCachedSecondCacheImpl";
                }
                secondCacheClass = Class.forName(classFullPath);
                Node secondAddressNode = this.xmlUtil.getFirstChildByName(secondNode, "address");
                secondCacheAddress = secondAddressNode.getTextContent().trim();
            }
        }
        catch (Exception e) {
            throw new LoadConfigException("parse db.cluster.cache failure", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IClusterConfig getInstance() throws LoadConfigException {
        if (instance != null) return instance;
        Class<XmlClusterConfigImpl> clazz = XmlClusterConfigImpl.class;
        synchronized (XmlClusterConfigImpl.class) {
            if (instance != null) return instance;
            instance = new XmlClusterConfigImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IClusterConfig getInstance(String xmlFilePath) throws LoadConfigException {
        if (instance != null) return instance;
        Class<XmlClusterConfigImpl> clazz = XmlClusterConfigImpl.class;
        synchronized (XmlClusterConfigImpl.class) {
            if (instance != null) return instance;
            instance = new XmlClusterConfigImpl(xmlFilePath);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public EnumDbConnectionPoolCatalog getDbConnectionPoolCatalog() {
        return enumCpCatalog;
    }

    @Override
    public int getIdGeneratorBatch() {
        return idGenerateBatch;
    }

    @Override
    public HashAlgoEnum getHashAlgo() {
        return hashAlgo;
    }

    @Override
    public Collection<DBClusterInfo> getDBClusterInfos() {
        return dbClusterInfos;
    }

    @Override
    public String getZookeeperUrl() {
        return zkUrl;
    }

    @Override
    public boolean isCacheEnabled() {
        return isCacheEnabled;
    }

    @Override
    public String getSecondCacheAddress() {
        return secondCacheAddress;
    }

    @Override
    public int getSecondCacheExpire() {
        return secondCacheExpire;
    }

    @Override
    public Class<ISecondCache> getSecondCacheClass() {
        return secondCacheClass;
    }

    @Override
    public String getPrimaryCacheAddress() {
        return primaryCacheAddress;
    }

    @Override
    public int getPrimaryCacheExpire() {
        return primaryCacheExpire;
    }

    @Override
    public Class<IPrimaryCache> getPrimaryCacheClass() {
        return primaryCacheClass;
    }

    static {
        dbClusterInfos = new ArrayList<DBClusterInfo>();
    }
}

