/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.enums;

import org.pinus4j.utils.HashUtil;

public enum HashAlgoEnum {
    ADDITIVE("additive"),
    ROTATING("rotating"),
    ONEBYONE("oneByOne"),
    BERNSTEIN("bernstein"),
    FNV("fnv"),
    RS("rs"),
    JS("js"),
    PJW("pjw"),
    ELF("elf"),
    BKDR("bkdr"),
    SDBM("sdbm"),
    DJB("djb"),
    DEK("dek"),
    AP("ap"),
    JAVA("java"),
    MIX("mix");

    private String value;

    private HashAlgoEnum(String value) {
        this.value = value;
    }

    public long hash(String key) {
        long hashValue = -1L;
        switch (this) {
            case ADDITIVE: {
                hashValue = HashUtil.additiveHash(key);
                break;
            }
            case AP: {
                hashValue = HashUtil.APHash(key);
                break;
            }
            case BERNSTEIN: {
                hashValue = HashUtil.bernstein(key);
                break;
            }
            case BKDR: {
                hashValue = HashUtil.BKDRHash(key);
                break;
            }
            case DEK: {
                hashValue = HashUtil.DEKHash(key);
                break;
            }
            case DJB: {
                hashValue = HashUtil.DJBHash(key);
                break;
            }
            case ELF: {
                hashValue = HashUtil.ELFHash(key);
                break;
            }
            case FNV: {
                hashValue = HashUtil.FNVHash1(key);
                break;
            }
            case JAVA: {
                hashValue = HashUtil.java(key);
                break;
            }
            case JS: {
                hashValue = HashUtil.JSHash(key);
                break;
            }
            case MIX: {
                hashValue = HashUtil.mixHash(key);
                break;
            }
            case ONEBYONE: {
                hashValue = HashUtil.oneByOneHash(key);
                break;
            }
            case PJW: {
                hashValue = HashUtil.PJWHash(key);
                break;
            }
            case ROTATING: {
                hashValue = HashUtil.rotatingHash(key);
                break;
            }
            case RS: {
                hashValue = HashUtil.RSHash(key);
                break;
            }
            case SDBM: {
                hashValue = HashUtil.SDBMHash(key);
            }
        }
        return Math.abs(hashValue);
    }

    public String getValue() {
        return this.value;
    }

    public static HashAlgoEnum getEnum(String value) {
        for (HashAlgoEnum type : HashAlgoEnum.values()) {
            if (!type.value.equals(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("\u627e\u4e0d\u5230\u76f8\u5173\u679a\u4e3e, value=" + value);
    }
}

