/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.impl;

import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.pinus4j.api.enums.EnumDB;
import org.pinus4j.cluster.beans.AppDBInfo;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.cluster.impl.AbstractDBCluster;
import org.pinus4j.exceptions.LoadConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDBClusterImpl
extends AbstractDBCluster {
    public static final Logger LOG = LoggerFactory.getLogger(AppDBClusterImpl.class);

    public AppDBClusterImpl(EnumDB enumDb) {
        super(enumDb);
    }

    @Override
    public void buildDataSource(DBInfo dbConnInfo) throws LoadConfigException {
        AppDBInfo appDbConnInfo = (AppDBInfo)dbConnInfo;
        LOG.info(dbConnInfo.toString());
        try {
            BasicDataSource ds = new BasicDataSource();
            ds.setDriverClassName(this.enumDb.getDriverClass());
            ds.setUsername(appDbConnInfo.getUsername());
            ds.setPassword(appDbConnInfo.getPassword());
            ds.setUrl(appDbConnInfo.getUrl());
            Map<String, Object> dbConnPoolInfo = appDbConnInfo.getConnPoolInfo();
            ds.setValidationQuery("SELECT 1");
            ds.setMaxActive(((Integer)dbConnPoolInfo.get("maxActive")).intValue());
            ds.setMinIdle(((Integer)dbConnPoolInfo.get("minIdle")).intValue());
            ds.setMaxIdle(((Integer)dbConnPoolInfo.get("maxIdle")).intValue());
            ds.setInitialSize(((Integer)dbConnPoolInfo.get("initialSize")).intValue());
            ds.setRemoveAbandoned(((Boolean)dbConnPoolInfo.get("removeAbandoned")).booleanValue());
            ds.setRemoveAbandonedTimeout(((Integer)dbConnPoolInfo.get("removeAbandonedTimeout")).intValue());
            ds.setMaxWait((long)((Integer)dbConnPoolInfo.get("maxWait")).intValue());
            ds.setTimeBetweenEvictionRunsMillis((long)((Integer)dbConnPoolInfo.get("timeBetweenEvictionRunsMillis")).intValue());
            ds.setNumTestsPerEvictionRun(((Integer)dbConnPoolInfo.get("numTestsPerEvictionRun")).intValue());
            ds.setMinEvictableIdleTimeMillis((long)((Integer)dbConnPoolInfo.get("minEvictableIdleTimeMillis")).intValue());
            dbConnInfo.setDatasource((DataSource)ds);
        }
        catch (Exception e) {
            throw new LoadConfigException(e);
        }
    }

    @Override
    public void closeDataSource(DBInfo dbConnInfo) {
        try {
            ((BasicDataSource)dbConnInfo.getDatasource()).close();
        }
        catch (SQLException e) {
            LOG.error(e.getMessage());
        }
    }
}

