/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.iterator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.QueryImpl;
import org.pinus4j.datalayer.IRecordIterator;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;

public abstract class AbstractRecordIterator<E>
extends AbstractJdbcQuery
implements IRecordIterator<E> {
    public static final int STEP = 5000;
    protected Class<E> clazz;
    protected String pkName;
    protected IQuery query;
    protected Queue<E> recordQ;
    protected int step = 5000;
    protected long latestId = 0L;
    protected long maxId;

    public AbstractRecordIterator(Class<E> clazz) {
        Class<?> type;
        this.pkName = ReflectUtil.getPkName(clazz);
        try {
            type = clazz.getDeclaredField(this.pkName).getType();
        }
        catch (NoSuchFieldException e) {
            throw new DBOperationException("\u904d\u5386\u6570\u636e\u5931\u8d25, clazz " + clazz, e);
        }
        catch (SecurityException e) {
            throw new DBOperationException("\u904d\u5386\u6570\u636e\u5931\u8d25, clazz " + clazz, e);
        }
        if (type != Long.TYPE && type != Integer.TYPE && type != Short.TYPE && type != Long.class && type != Long.class && type != Short.class) {
            throw new DBOperationException("\u88ab\u904d\u5386\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u662f\u6570\u503c\u578b");
        }
        this.clazz = clazz;
        if (this.query == null) {
            this.query = new QueryImpl();
        }
        this.recordQ = new LinkedList();
    }

    @Override
    public E next() {
        return this.recordQ.poll();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("this iterator cann't doing remove");
    }

    @Override
    public List<E> nextMore() {
        ArrayList<E> data = new ArrayList<E>(this.recordQ);
        this.recordQ.clear();
        return data;
    }

    @Override
    public void setQuery(IQuery query) {
        if (query != null) {
            this.query = query;
        }
    }

    public abstract long getMaxId();

    public int getStep() {
        return this.step;
    }

    @Override
    public void setStep(int step) {
        this.step = step;
    }
}

