/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.iterator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.pinus4j.api.query.Condition;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.Order;
import org.pinus4j.api.query.QueryImpl;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.iterator.AbstractRecordIterator;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalRecordIterator<E>
extends AbstractRecordIterator<E> {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalRecordIterator.class);
    private DBInfo dbConnInfo;

    public GlobalRecordIterator(DBInfo dbConnInfo, Class<E> clazz) {
        super(clazz);
        this.dbConnInfo = dbConnInfo;
        this.maxId = this.getMaxId();
    }

    @Override
    public long getMaxId() {
        long maxId = 0L;
        QueryImpl query = new QueryImpl();
        query.limit(1).orderBy(this.pkName, Order.DESC);
        List one = null;
        try {
            one = this.selectGlobalByQuery(this.dbConnInfo.getDatasource().getConnection(), query, this.clazz);
        }
        catch (SQLException e1) {
            throw new DBOperationException("\u83b7\u53d6max id\u5931\u8d25");
        }
        if (!one.isEmpty()) {
            Object e = one.get(0);
            maxId = ReflectUtil.getPkValue(e).longValue();
        }
        LOG.info("clazz " + this.clazz + " maxId=" + maxId);
        return maxId;
    }

    @Override
    public long getCount() {
        return this.selectGlobalCount(this.query, this.dbConnInfo, this.dbConnInfo.getClusterName(), this.clazz).longValue();
    }

    @Override
    public boolean hasNext() {
        block11: {
            List recrods;
            if (!this.recordQ.isEmpty()) break block11;
            IQuery query = this.query.clone();
            long high = this.latestId + (long)this.step;
            query.add(Condition.gte(this.pkName, this.latestId)).add(Condition.lt(this.pkName, high));
            Connection conn = null;
            try {
                conn = this.dbConnInfo.getDatasource().getConnection();
                recrods = this.selectGlobalByQuery(conn, query, this.clazz);
            }
            catch (SQLException e) {
                try {
                    throw new DBOperationException(e);
                }
                catch (Throwable throwable) {
                    SQLBuilder.close(conn);
                    throw throwable;
                }
            }
            SQLBuilder.close(conn);
            this.latestId = high;
            while (recrods.isEmpty() && this.latestId < this.maxId) {
                query = this.query.clone();
                high = this.latestId + (long)this.step;
                query.add(Condition.gte(this.pkName, this.latestId)).add(Condition.lt(this.pkName, high));
                try {
                    conn = this.dbConnInfo.getDatasource().getConnection();
                    recrods = this.selectGlobalByQuery(conn, query, this.clazz);
                }
                catch (SQLException e) {
                    throw new DBOperationException(e);
                }
                finally {
                    SQLBuilder.close(conn);
                }
                this.latestId = high;
            }
            this.recordQ.addAll(recrods);
        }
        return !this.recordQ.isEmpty();
    }
}

