/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.iterator;

import java.util.List;
import org.pinus4j.api.query.Condition;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.Order;
import org.pinus4j.api.query.QueryImpl;
import org.pinus4j.cluster.DB;
import org.pinus4j.datalayer.iterator.AbstractRecordIterator;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingRecordIterator<E>
extends AbstractRecordIterator<E> {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingRecordIterator.class);
    private DB db;

    public ShardingRecordIterator(DB db, Class<E> clazz) {
        super(clazz);
        this.db = db;
        this.maxId = this.getMaxId();
    }

    @Override
    public long getMaxId() {
        long maxId = 0L;
        QueryImpl query = new QueryImpl();
        query.limit(1).orderBy(this.pkName, Order.DESC);
        List one = this.selectByQuery(this.db, query, this.clazz);
        if (!one.isEmpty()) {
            Object e = one.get(0);
            maxId = ReflectUtil.getPkValue(e).longValue();
        }
        LOG.info("clazz " + this.clazz + " DB " + this.db + " maxId=" + maxId);
        return maxId;
    }

    @Override
    public long getCount() {
        return this.selectCount(this.db, this.clazz, this.query).longValue();
    }

    @Override
    public boolean hasNext() {
        if (this.recordQ.isEmpty()) {
            IQuery query = this.query.clone();
            long high = this.latestId + (long)this.step;
            query.add(Condition.gte(this.pkName, this.latestId)).add(Condition.lt(this.pkName, high));
            List recrods = this.selectByQuery(this.db, query, this.clazz);
            this.latestId = high;
            while (recrods.isEmpty() && this.latestId < this.maxId) {
                query = this.query.clone();
                high = this.latestId + (long)this.step;
                query.add(Condition.gte(this.pkName, this.latestId)).add(Condition.lt(this.pkName, high));
                recrods = this.selectByQuery(this.db, query, this.clazz);
                this.latestId = high;
            }
            this.recordQ.addAll(recrods);
        }
        return !this.recordQ.isEmpty();
    }
}

