/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.datalayer.IDataUpdate;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.generator.IIdGenerator;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcUpdate
implements IDataUpdate {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcUpdate.class);
    protected IDBCluster dbCluster;
    protected IIdGenerator idGenerator;
    protected IPrimaryCache primaryCache;
    protected ISecondCache secondCache;

    protected void _saveBatch(Connection conn, List<? extends Object> entities, int tableIndex) {
        Statement st = null;
        try {
            conn.setAutoCommit(false);
            st = SQLBuilder.getInsert(conn, entities, tableIndex);
            st.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    LOG.error(e1.getMessage());
                }
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(st);
                throw throwable;
            }
        }
        SQLBuilder.close(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeByPks(Connection conn, List<? extends Number> pks, Class<?> clazz, int tableIndex) {
        PreparedStatement ps = null;
        try {
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(SQLBuilder.buildDeleteByPks(clazz, tableIndex, pks));
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    LOG.error(e1.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLBuilder.close(null, ps);
                throw throwable;
            }
            SQLBuilder.close(null, ps);
        }
        SQLBuilder.close(null, ps);
    }

    protected void _updateBatch(Connection conn, List<? extends Object> entities, int tableIndex) {
        Statement st = null;
        try {
            conn.setAutoCommit(false);
            st = SQLBuilder.getUpdate(conn, entities, tableIndex);
            st.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    LOG.error(e1.getMessage());
                }
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(st);
                throw throwable;
            }
        }
        SQLBuilder.close(st);
    }

    protected boolean isCacheAvailable(Class<?> clazz) {
        return this.primaryCache != null && ReflectUtil.isCache(clazz);
    }

    protected boolean isSecondCacheAvailable(Class<?> clazz) {
        return this.secondCache != null && ReflectUtil.isCache(clazz);
    }

    @Override
    public IDBCluster getDBCluster() {
        return this.dbCluster;
    }

    @Override
    public void setDBCluster(IDBCluster dbCluster) {
        this.dbCluster = dbCluster;
    }

    @Override
    public void setIdGenerator(IIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public IIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public IPrimaryCache getPrimaryCache() {
        return this.primaryCache;
    }

    @Override
    public void setPrimaryCache(IPrimaryCache primaryCache) {
        this.primaryCache = primaryCache;
    }

    @Override
    public ISecondCache getSecondCache() {
        return this.secondCache;
    }

    @Override
    public void setSecondCache(ISecondCache secondCache) {
        this.secondCache = secondCache;
    }
}

