/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.datalayer.IGlobalMasterQuery;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJdbcMasterQueryImpl
extends AbstractJdbcQuery
implements IGlobalMasterQuery {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalJdbcMasterQueryImpl.class);

    @Override
    public <T> T findGlobalOneByQueryFromMaster(IQuery query, String clusterName, Class<T> clazz, boolean useCache) {
        List<T> entities = this.findGlobalByQueryFromMaster(query, clusterName, clazz, useCache);
        if (entities.isEmpty()) {
            return null;
        }
        try {
            if (query.hasQueryFields()) {
                Object obj = ReflectUtil.cloneWithGivenField(entities.get(0), query.getFields());
                return (T)obj;
            }
            T obj = entities.get(0);
            return obj;
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public Number getGlobalCountFromMaster(String clusterName, Class<?> clazz, boolean useCache) {
        DBInfo globalConnection;
        try {
            globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        long count = this.selectGlobalCountWithCache(globalConnection, clusterName, clazz, useCache).longValue();
        return count;
    }

    @Override
    public Number getGlobalCountFromMaster(IQuery query, String clusterName, Class<?> clazz) {
        DBInfo globalConnection;
        try {
            globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        long count = this.selectGlobalCount(query, globalConnection, clusterName, clazz).longValue();
        return count;
    }

    @Override
    public <T> T findGlobalByPkFromMaster(Number pk, String clusterName, Class<T> clazz) {
        return this.findGlobalByPkFromMaster(pk, clusterName, clazz, true);
    }

    @Override
    public <T> T findGlobalByPkFromMaster(Number pk, String clusterName, Class<T> clazz, boolean useCache) {
        T t;
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
            conn = globalConnection.getDatasource().getConnection();
            t = this.selectByPkWithCache(conn, clusterName, pk, clazz, useCache);
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return t;
    }

    @Override
    public <T> List<T> findGlobalByPksFromMaster(String clusterName, Class<T> clazz, Number ... pks) {
        return this.findGlobalByPksFromMaster(clusterName, clazz, true, pks);
    }

    @Override
    public <T> List<T> findGlobalByPksFromMaster(String clusterName, Class<T> clazz, boolean useCache, Number ... pks) {
        List<T> list;
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
            conn = globalConnection.getDatasource().getConnection();
            list = this.selectGlobalByPksWithCache(conn, clusterName, clazz, pks, useCache);
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return list;
    }

    @Override
    public <T> List<T> findGlobalByPkListFromMaster(List<? extends Number> pks, String clusterName, Class<T> clazz, boolean useCache) {
        List<T> list;
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
            conn = globalConnection.getDatasource().getConnection();
            list = this.selectGlobalByPksWithCache(conn, clusterName, clazz, pks.toArray(new Number[pks.size()]), useCache);
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return list;
    }

    public List<Map<String, Object>> findGlobalBySqlFromMaster(SQL sql, String clusterName) {
        List<Map<String, Object>> list;
        Connection conn = null;
        try {
            List<Map<String, Object>> result;
            DBInfo globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
            conn = globalConnection.getDatasource().getConnection();
            list = result = this.selectGlobalBySql(conn, sql);
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return list;
    }

    @Override
    public <T> List<T> findGlobalByQueryFromMaster(IQuery query, String clusterName, Class<T> clazz, boolean useCache) {
        List<T> list;
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
            conn = globalConnection.getDatasource().getConnection();
            List<T> result = null;
            String tableName = ReflectUtil.getTableName(clazz);
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                result = this.secondCache.getGlobal(query, clusterName, tableName);
            }
            if (result == null || result.isEmpty()) {
                if (this.isCacheAvailable(clazz, useCache)) {
                    Number[] pkValues = this.selectGlobalPksByQuery(conn, query, clazz);
                    result = this.selectGlobalByPksWithCache(conn, clusterName, clazz, pkValues, useCache);
                } else {
                    result = this.selectGlobalByQuery(conn, query, clazz);
                }
                if (this.isSecondCacheAvailable(clazz, useCache)) {
                    this.secondCache.putGlobal(query, clusterName, tableName, result);
                }
            }
            ArrayList<T> filteResult = new ArrayList<T>(result.size());
            if (query.hasQueryFields()) {
                for (Object obj : result) {
                    filteResult.add(ReflectUtil.cloneWithGivenField(obj, query.getFields()));
                }
                result = filteResult;
            }
            list = result;
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return list;
    }
}

