/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.datalayer.IGlobalUpdate;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.jdbc.AbstractJdbcUpdate;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJdbcUpdateImpl
extends AbstractJdbcUpdate
implements IGlobalUpdate {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalJdbcUpdateImpl.class);

    @Override
    public Number globalSave(Object entity, String clusterName) {
        ArrayList<Object> entities = new ArrayList<Object>(1);
        entities.add(entity);
        return this.globalSaveBatch(entities, clusterName)[0];
    }

    @Override
    public Number[] globalSaveBatch(List<? extends Object> entities, String clusterName) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = ReflectUtil.getTableName(clazz);
        int entitySize = entities.size();
        Number[] pks = new Number[entitySize];
        boolean isCheckPrimaryKey = true;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>(entitySize);
        Number pk = null;
        Number maxPk = 0;
        Object entity = null;
        for (int i = 0; i < entitySize; ++i) {
            entity = entities.get(i);
            pk = ReflectUtil.getPkValue(entity);
            if (pk == null || pk.intValue() == 0) {
                map.put(i, entity);
                continue;
            }
            pks[i] = pk;
            maxPk = pk.intValue() > maxPk ? (Number)pk : (Number)maxPk;
        }
        if (!map.isEmpty()) {
            isCheckPrimaryKey = false;
            int[] newPks = this.idGenerator.genClusterUniqueIntIdBatch("/pinus/primarykey/" + clusterName, tableName, map.size(), ((Number)maxPk).longValue());
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                int pos = ((Number)entry.getKey()).intValue();
                try {
                    ReflectUtil.setPkValue(entities.get(pos), newPks[i]);
                }
                catch (Exception e) {
                    throw new DBOperationException(e);
                }
                pks[pos] = newPks[i];
                ++i;
            }
        }
        if (isCheckPrimaryKey) {
            this.idGenerator.checkAndSetPrimaryKey(((Number)maxPk).longValue(), clusterName, tableName);
        }
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
            conn = globalConnection.getDatasource().getConnection();
            this._saveBatchGlobal(conn, entities);
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.incrCountGlobal(clusterName, tableName, entities.size());
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e1) {
            try {
                throw new DBOperationException(e1);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return pks;
    }

    @Override
    public void globalUpdate(Object entity, String clusterName) {
        ArrayList<Object> entities = new ArrayList<Object>();
        entities.add(entity);
        this.globalUpdateBatch(entities, clusterName);
    }

    @Override
    public void globalUpdateBatch(List<? extends Object> entities, String clusterName) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = ReflectUtil.getTableName(clazz);
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
            conn = globalConnection.getDatasource().getConnection();
            this._updateBatchGlobal(conn, entities);
            if (this.isCacheAvailable(clazz)) {
                ArrayList<Number> pks = new ArrayList<Number>(entities.size());
                for (Object object : entities) {
                    pks.add(ReflectUtil.getPkValue(object));
                }
                this.primaryCache.removeGlobal(clusterName, tableName, pks);
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
    }

    @Override
    public void globalRemoveByPk(Number pk, Class<?> clazz, String clusterName) {
        ArrayList<Number> pks = new ArrayList<Number>(1);
        pks.add(pk);
        this.globalRemoveByPks(pks, clazz, clusterName);
    }

    @Override
    public void globalRemoveByPks(List<? extends Number> pks, Class<?> clazz, String clusterName) {
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getMasterGlobalConn(clusterName);
            conn = globalConnection.getDatasource().getConnection();
            this._removeByPksGlobal(conn, pks, clazz);
            String tableName = ReflectUtil.getTableName(clazz);
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.removeGlobal(clusterName, tableName, pks);
                this.primaryCache.decrCountGlobal(clusterName, tableName, pks.size());
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
    }

    private void _saveBatchGlobal(Connection conn, List<? extends Object> entities) {
        this._saveBatch(conn, entities, -1);
    }

    private void _updateBatchGlobal(Connection conn, List<? extends Object> entities) {
        this._updateBatch(conn, entities, -1);
    }

    private void _removeByPksGlobal(Connection conn, List<? extends Number> pks, Class<?> clazz) {
        this._removeByPks(conn, pks, clazz, -1);
    }
}

