/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.utils;

import java.util.List;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.SQL;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.generator.annotations.Table;
import org.pinus4j.utils.StringUtils;

public class CheckUtil {
    public static void checkLimit(int start, int limit) {
        if (start < 0 || limit <= 0) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef, start=" + start + ", limit=" + limit);
        }
    }

    public static void checkClusterName(String clusterName) {
        if (StringUtils.isBlank(clusterName)) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, clusterName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void checkEnumMasterSlave(EnumDBMasterSlave clusterType) {
        if (clusterType == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, EnumDBMasterSlave=null");
        }
    }

    public static void checkQuery(IQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, Query=" + query);
        }
    }

    public static void checkSQL(SQL sql) {
        if (sql == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, SQL=" + sql);
        }
        if (sql.getSql() == null || sql.getSql().equals("")) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, SQL\u7684sql\u8bed\u53e5\u4e3a\u7a7a");
        }
    }

    public static void checkNumberGtZero(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, number=" + number);
        }
        if (number.intValue() <= 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, number=" + number);
        }
    }

    public static void checkNumberList(List<? extends Number> numbers) {
        if (numbers == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, list=" + numbers);
        }
    }

    public static void checkEntityList(List<? extends Object> entityList) {
        if (entityList == null || entityList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, entity list=" + entityList);
        }
    }

    public static void checkShardingValue(IShardingKey<?> shardingKey) {
        if (shardingKey == null || StringUtils.isBlank(shardingKey.getClusterName())) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, shardingKey=" + shardingKey);
        }
        if (shardingKey.getValue() instanceof Number) {
            if (shardingKey.getValue() == null || ((Number)shardingKey.getValue()).intValue() == 0) {
                throw new DBOperationException("sharding value cann't be null or number zero when sharding value type is number");
            }
        } else if (shardingKey.getValue() instanceof String) {
            if (shardingKey.getValue() == null) {
                throw new DBOperationException("\u4f7f\u7528String\u505aSharding\u65f6\uff0cShardingKey\u7684\u503c\u4e0d\u80fd\u4e3aNull");
            }
        } else {
            throw new DBOperationException("\u4e0d\u652f\u6301\u7684ShardingKey\u7c7b\u578b, \u53ea\u652f\u6301Number\u6216String");
        }
    }

    public static void checkShardingValueList(List<IShardingKey<?>> shardingValueList) {
        if (shardingValueList == null || shardingValueList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, sharding value list=" + shardingValueList);
        }
    }

    public static void checkClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, clazz=" + clazz);
        }
    }

    public static void checkShardingEntity(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, entity=" + entity);
        }
        Class<?> clazz = entity.getClass();
        Table table = clazz.getAnnotation(Table.class);
        if (table == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, \u5b9e\u4f53\u5bf9\u8c61\u9700\u8981\u4f7f\u7528@Table\u6ce8\u89e3, class=" + clazz);
        }
        String clusterName = table.cluster();
        String shardingField = table.shardingBy();
        int shardingNum = table.shardingNum();
        if (StringUtils.isBlank(clusterName) || StringUtils.isBlank(shardingField) || shardingNum <= 0) {
            throw new IllegalArgumentException("\u88ab\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e0d\u662fShardingEntity, class=" + clazz);
        }
    }

    public static void checkGlobalEntity(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, entity=" + entity);
        }
        Class<?> clazz = entity.getClass();
        Table table = clazz.getAnnotation(Table.class);
        if (table == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, \u5b9e\u4f53\u5bf9\u8c61\u9700\u8981\u4f7f\u7528@Table\u6ce8\u89e3, class=" + clazz);
        }
        String clusterName = table.cluster();
        String shardingField = table.shardingBy();
        int shardingNum = table.shardingNum();
        if (StringUtils.isBlank(clusterName) || StringUtils.isNotBlank(shardingField) || shardingNum > 0) {
            throw new IllegalArgumentException("\u88ab\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e0d\u662fGlobalEntity class=" + clazz);
        }
    }
}

