/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.utils;

import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPool {
    private ThreadPoolExecutor pool = null;
    private static final int QUEUE_SIZE = 50000;

    private ThreadPool(String poolName, int minThread, int maxThread, long waitTime) {
        this.pool = new ThreadPoolExecutor(minThread, maxThread, waitTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.getQueueSize()), new NameThreadFactory(poolName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ThreadPool newInstance(String poolName) {
        int minThread = Runtime.getRuntime().availableProcessors() * 2;
        int maxThread = minThread * 4;
        long waitTime = 3000L;
        return ThreadPool.newInstance(poolName, minThread, maxThread, waitTime);
    }

    public static ThreadPool newInstance(String poolName, int minThread, int maxThread, long waitTime) {
        return new ThreadPool(poolName, minThread, maxThread, waitTime);
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.pool;
    }

    public int getQueueSize() {
        return 50000;
    }

    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    public void execute(Runnable r) {
        this.pool.execute(r);
    }

    public Future<?> submit(Runnable r) {
        return this.pool.submit(r);
    }

    private class NameThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public NameThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolName + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

