/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api;

import org.pinus4j.api.IShardingStorageClient;
import org.pinus4j.api.ShardingKey;
import org.pinus4j.api.ShardingStorageClientImpl;
import org.pinus4j.utils.ReflectUtil;

public abstract class FashionEntity {
    public Number save() {
        Number pk = null;
        IShardingStorageClient storageClient = ShardingStorageClientImpl.instance;
        pk = ReflectUtil.isShardingEntity(this.getClass()) ? (Number)storageClient.save(this) : (Number)storageClient.globalSave(this);
        return pk;
    }

    public void update() {
        IShardingStorageClient storageClient = ShardingStorageClientImpl.instance;
        if (ReflectUtil.isShardingEntity(this.getClass())) {
            storageClient.update(this);
        } else {
            storageClient.globalUpdate(this);
        }
    }

    public Number saveOrUpdate() {
        Number pk = ReflectUtil.getPkValue(this);
        if (pk.intValue() == 0) {
            return this.save();
        }
        Object obj = null;
        Class<?> clazz = this.getClass();
        String clusterName = ReflectUtil.getClusterName(clazz);
        IShardingStorageClient storageClient = ShardingStorageClientImpl.instance;
        if (ReflectUtil.isShardingEntity(clazz)) {
            Object shardingValue = ReflectUtil.getShardingValue(this);
            ShardingKey<Object> sk = new ShardingKey<Object>(clusterName, shardingValue);
            obj = storageClient.findByPk(pk, sk, clazz);
        } else {
            obj = storageClient.findGlobalByPk(pk, clusterName, clazz);
        }
        if (obj != null) {
            this.update();
            return pk;
        }
        return this.save();
    }

    public void remove() {
        Number pk = ReflectUtil.getPkValue(this);
        if (pk.intValue() == 0) {
            return;
        }
        Class<?> clazz = this.getClass();
        String clusterName = ReflectUtil.getClusterName(clazz);
        IShardingStorageClient storageClient = ShardingStorageClientImpl.instance;
        if (ReflectUtil.isShardingEntity(this.getClass())) {
            Object shardingValue = ReflectUtil.getShardingValue(this);
            ShardingKey<Object> sk = new ShardingKey<Object>(clusterName, shardingValue);
            storageClient.removeByPk(pk, sk, clazz);
        } else {
            storageClient.globalRemoveByPk(pk, clazz, clusterName);
        }
    }
}

