/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api.query;

import java.util.ArrayList;
import java.util.List;
import org.pinus4j.api.query.Condition;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.Order;
import org.pinus4j.utils.StringUtils;

public class QueryImpl
implements IQuery,
Cloneable {
    private String[] fields;
    private List<Condition> condList = new ArrayList<Condition>();
    private List<OrderBy> orderList = new ArrayList<OrderBy>();
    private int start = -1;
    private int limit = -1;

    @Override
    public boolean hasQueryFields() {
        return this.fields != null && this.fields.length > 0;
    }

    @Override
    public IQuery clone() {
        QueryImpl clone = new QueryImpl();
        clone.setFields(this.fields);
        clone.setCondList(new ArrayList<Condition>(this.condList));
        clone.setOrderList(new ArrayList<OrderBy>(this.orderList));
        clone.setStart(this.start);
        clone.setLimit(this.limit);
        return clone;
    }

    @Override
    public IQuery setFields(String ... fields) {
        if (fields != null && fields.length > 0) {
            this.fields = fields;
        }
        return this;
    }

    @Override
    public String[] getFields() {
        return this.fields;
    }

    @Override
    public String getWhereSql() {
        StringBuilder SQL2 = new StringBuilder();
        if (!this.condList.isEmpty()) {
            SQL2.append(" WHERE ");
            for (Condition cond : this.condList) {
                SQL2.append(cond.getSql()).append(" AND ");
            }
            SQL2.delete(SQL2.lastIndexOf(" AND "), SQL2.length());
        }
        if (!this.orderList.isEmpty()) {
            SQL2.append(" ORDER BY ");
            for (OrderBy orderBy : this.orderList) {
                SQL2.append(orderBy.getField());
                SQL2.append(" ");
                SQL2.append(orderBy.getOrder().getValue());
                SQL2.append(",");
            }
            SQL2.deleteCharAt(SQL2.length() - 1);
        }
        if (this.start != -1 && this.limit != -1) {
            SQL2.append(" LIMIT ").append(this.start).append(",").append(this.limit);
        } else if (this.limit != -1) {
            SQL2.append(" LIMIT ").append(this.limit);
        }
        return SQL2.toString();
    }

    @Override
    public IQuery add(Condition cond) {
        if (cond == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, cond=null");
        }
        this.condList.add(cond);
        return this;
    }

    @Override
    public IQuery orderBy(String field, Order order) {
        if (StringUtils.isBlank(field)) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, field=" + field);
        }
        if (order == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, order=null");
        }
        this.orderList.add(new OrderBy(field, order));
        return this;
    }

    @Override
    public IQuery limit(int start, int limit) {
        if (start < 0 || limit <= 0) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef, start" + start + ", limit=" + limit);
        }
        this.start = start;
        this.limit = limit;
        return this;
    }

    @Override
    public IQuery limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("\u8bbe\u7f6elimit\u53c2\u6570\u9519\u8bef\uff0c limit=" + limit);
        }
        this.limit = limit;
        return this;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        if (this.fields != null && this.fields.length > 0) {
            info.append("fields:");
            for (String field : this.fields) {
                info.append(field).append(",");
            }
            info.deleteCharAt(info.length() - 1);
        }
        if (StringUtils.isNotBlank(this.getWhereSql())) {
            info.append(" wheresql:").append(this.getWhereSql());
        }
        return info.toString();
    }

    public void setCondList(List<Condition> condList) {
        this.condList = condList;
    }

    public void setOrderList(List<OrderBy> orderList) {
        this.orderList = orderList;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    private class OrderBy {
        private String field;
        private Order order;

        public OrderBy(String field, Order order) {
            this.field = field;
            this.order = order;
        }

        public String getField() {
            return this.field;
        }

        public Order getOrder() {
            return this.order;
        }
    }
}

