/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cache.impl;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import net.spy.memcached.MemcachedClient;
import org.pinus4j.cache.ICache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMemCachedCache
implements ICache {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractMemCachedCache.class);
    protected MemcachedClient memClient;
    protected int expire = 30;

    public AbstractMemCachedCache(String address, int expire) {
        this.expire = expire;
        try {
            ArrayList<InetSocketAddress> servers = new ArrayList<InetSocketAddress>();
            String[] addresses = address.split(",");
            InetSocketAddress socketAddress = null;
            for (String addr : addresses) {
                String[] pair = addr.split(":");
                socketAddress = new InetSocketAddress(pair[0], Integer.parseInt(pair[1]));
                servers.add(socketAddress);
            }
            this.memClient = new MemcachedClient(servers);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8fde\u63a5memcached\u670d\u52a1\u5668\u5931\u8d25", e);
        }
        if (expire > 0) {
            this.expire = expire;
        }
    }

    @Override
    public int getExpire() {
        return this.expire;
    }

    @Override
    public void close() {
        this.memClient.shutdown();
    }
}

