/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.impl;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pinus4j.api.enums.EnumDB;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.cluster.beans.EnvDBInfo;
import org.pinus4j.cluster.impl.AbstractDBCluster;
import org.pinus4j.exceptions.LoadConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvDBClusterImpl
extends AbstractDBCluster {
    public static final Logger LOG = LoggerFactory.getLogger(EnvDBClusterImpl.class);
    private Context initCtx;

    public EnvDBClusterImpl(EnumDB enumDb) {
        super(enumDb);
        try {
            this.initCtx = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void buildDataSource(DBInfo dbConnInfo) throws LoadConfigException {
        EnvDBInfo envDbConnInfo = (EnvDBInfo)dbConnInfo;
        LOG.info(envDbConnInfo.toString());
        try {
            DataSource ds = (DataSource)this.initCtx.lookup(envDbConnInfo.getEnvDsName());
            dbConnInfo.setDatasource(ds);
        }
        catch (NamingException e) {
            throw new LoadConfigException("load jndi datasource failure, env name " + envDbConnInfo.getEnvDsName());
        }
    }

    @Override
    public void closeDataSource(DBInfo dbConnInfo) {
    }
}

