/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.router.impl;

import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.cluster.ITableCluster;
import org.pinus4j.cluster.beans.DBClusterInfo;
import org.pinus4j.cluster.enums.HashAlgoEnum;
import org.pinus4j.cluster.router.IClusterRouter;
import org.pinus4j.cluster.router.IClusterRouterBuilder;

public class DefaultClusterRouterBuilder
implements IClusterRouterBuilder {
    private ThreadLocal<HashAlgoEnum> hashAlgoLocal = new ThreadLocal();
    private IDBCluster dbCluster;
    private ITableCluster tableCluster;

    private DefaultClusterRouterBuilder() {
        this.hashAlgoLocal.set(HashAlgoEnum.BERNSTEIN);
    }

    public static IClusterRouterBuilder valueOf(IDBCluster dbCluster) {
        DefaultClusterRouterBuilder builder = new DefaultClusterRouterBuilder();
        builder.setDBCluster(dbCluster);
        builder.setTableCluster(dbCluster.getTableCluster());
        return builder;
    }

    @Override
    public IClusterRouter build(String clusterName) {
        DBClusterInfo dbClusterInfo = this.dbCluster.getDBClusterInfo(clusterName);
        if (dbClusterInfo == null) {
            throw new IllegalStateException("can not found db cluster " + clusterName);
        }
        Class<IClusterRouter> routerClass = dbClusterInfo.getRouterClass();
        IClusterRouter clusterRouter = null;
        try {
            clusterRouter = routerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("create new cluster router failure", e);
        }
        clusterRouter.setHashAlgo(this.getHashAlgo());
        clusterRouter.setDBCluster(this.dbCluster);
        clusterRouter.setTableCluster(this.tableCluster);
        return clusterRouter;
    }

    @Override
    public HashAlgoEnum getHashAlgo() {
        return this.hashAlgoLocal.get();
    }

    @Override
    public void setHashAlgo(HashAlgoEnum hashAlgo) {
        this.hashAlgoLocal.set(hashAlgo);
    }

    public IDBCluster getDBCluster() {
        return this.dbCluster;
    }

    public void setDBCluster(IDBCluster dbCluster) {
        this.dbCluster = dbCluster;
    }

    public ITableCluster getTableCluster() {
        return this.tableCluster;
    }

    public void setTableCluster(ITableCluster tableCluster) {
        this.tableCluster = tableCluster;
    }
}

