/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.DB;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.datalayer.IDataQuery;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.SlowQueryLogger;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;

public abstract class AbstractJdbcQuery
implements IDataQuery {
    protected IDBCluster dbCluster;
    protected IPrimaryCache primaryCache;
    protected ISecondCache secondCache;

    protected boolean isCacheAvailable(Class<?> clazz, boolean useCache) {
        return this.primaryCache != null && ReflectUtil.isCache(clazz) && useCache;
    }

    protected boolean isSecondCacheAvailable(Class<?> clazz, boolean useCache) {
        return this.secondCache != null && ReflectUtil.isCache(clazz) && useCache;
    }

    private Number _selectGlobalCount(Connection conn, Class<?> clazz) {
        Long l;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = SQLBuilder.buildSelectCountGlobalSql(clazz);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 2000L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            long count = -1L;
            if (rs.next()) {
                count = rs.getLong(1);
            }
            l = count;
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(null, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(null, ps, rs);
        return l;
    }

    protected Number selectGlobalCount(IQuery query, DBInfo dbConnInfo, String clusterName, Class<?> clazz) {
        long count = 0L;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = dbConnInfo.getDatasource().getConnection();
            String sql = SQLBuilder.buildSelectCountGlobalSql(clazz, query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 2000L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            if (rs.next()) {
                count = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(conn, ps, rs);
        return count;
    }

    protected Number selectGlobalCountWithCache(DBInfo dbConnInfo, String clusterName, Class<?> clazz, boolean useCache) {
        long count;
        String tableName = ReflectUtil.getTableName(clazz);
        if (this.isCacheAvailable(clazz, useCache) && (count = this.primaryCache.getCountGlobal(clusterName, tableName)) > 0L) {
            return count;
        }
        count = 0L;
        Connection conn = null;
        try {
            conn = dbConnInfo.getDatasource().getConnection();
            count = this._selectGlobalCount(conn, clazz).longValue();
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
        finally {
            SQLBuilder.close(conn);
        }
        if (this.isCacheAvailable(clazz, useCache) && count > 0L) {
            this.primaryCache.setCountGlobal(clusterName, tableName, count);
        }
        return count;
    }

    private Number _selectCount(DB db, Class<?> clazz) {
        Long l;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = db.getDatasource().getConnection();
            String sql = SQLBuilder.buildSelectCountSql(clazz, db.getTableIndex());
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 2000L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            long count = -1L;
            if (rs.next()) {
                count = rs.getLong(1);
            }
            l = count;
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(conn, ps, rs);
        return l;
    }

    protected Number selectCountWithCache(DB db, Class<?> clazz, boolean useCache) {
        long count;
        if (this.isCacheAvailable(clazz, useCache) && (count = this.primaryCache.getCount(db)) > 0L) {
            return count;
        }
        count = this._selectCount(db, clazz).longValue();
        if (this.isCacheAvailable(clazz, useCache) && count > 0L) {
            this.primaryCache.setCount(db, count);
        }
        return count;
    }

    protected Number selectCount(DB db, Class<?> clazz, IQuery query) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block5: {
            Long l;
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = db.getDatasource().getConnection();
                String sql = SQLBuilder.buildSelectCountByQuery(clazz, db.getTableIndex(), query);
                ps = conn.prepareStatement(sql);
                long begin = System.currentTimeMillis();
                rs = ps.executeQuery();
                long constTime = System.currentTimeMillis() - begin;
                if (constTime > 2000L) {
                    SlowQueryLogger.write(db, sql, constTime);
                }
                if (!rs.next()) break block5;
                l = rs.getLong(1);
            }
            catch (SQLException e) {
                try {
                    throw new DBOperationException(e);
                }
                catch (Throwable throwable) {
                    SQLBuilder.close(conn, ps, rs);
                    throw throwable;
                }
            }
            SQLBuilder.close(conn, ps, rs);
            return l;
        }
        SQLBuilder.close(conn, ps, rs);
        return -1;
    }

    private <T> T _selectGlobalByPk(Connection conn, Number pk, Class<T> clazz) {
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            T t;
            ps = null;
            rs = null;
            try {
                List<T> result;
                String sql = SQLBuilder.buildSelectByPk(pk, clazz, -1);
                ps = conn.prepareStatement(sql);
                long begin = System.currentTimeMillis();
                rs = ps.executeQuery();
                long constTime = System.currentTimeMillis() - begin;
                if (constTime > 1L) {
                    SlowQueryLogger.write(conn, sql, constTime);
                }
                if ((result = SQLBuilder.buildResultObject(clazz, rs)).isEmpty()) break block5;
                t = result.get(0);
            }
            catch (SQLException e) {
                try {
                    throw new DBOperationException(e);
                }
                catch (Throwable throwable) {
                    SQLBuilder.close(null, ps, rs);
                    throw throwable;
                }
            }
            SQLBuilder.close(null, ps, rs);
            return t;
        }
        SQLBuilder.close(null, ps, rs);
        return null;
    }

    protected <T> T selectByPkWithCache(Connection conn, String clusterName, Number pk, Class<T> clazz, boolean useCache) {
        String tableName = ReflectUtil.getTableName(clazz);
        T data = null;
        if (this.isCacheAvailable(clazz, useCache)) {
            data = this.primaryCache.getGlobal(clusterName, tableName, pk);
            if (data == null && (data = (T)this._selectGlobalByPk(conn, pk, clazz)) != null) {
                this.primaryCache.putGlobal(clusterName, tableName, pk, data);
            }
        } else {
            data = this._selectGlobalByPk(conn, pk, clazz);
        }
        return data;
    }

    private <T> T _selectByPk(DB db, Number pk, Class<T> clazz) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block5: {
            T t;
            conn = null;
            ps = null;
            rs = null;
            try {
                List<T> result;
                conn = db.getDatasource().getConnection();
                String sql = SQLBuilder.buildSelectByPk(pk, clazz, db.getTableIndex());
                ps = conn.prepareStatement(sql);
                long begin = System.currentTimeMillis();
                rs = ps.executeQuery();
                long constTime = System.currentTimeMillis() - begin;
                if (constTime > 1L) {
                    SlowQueryLogger.write(db, sql, constTime);
                }
                if ((result = SQLBuilder.buildResultObject(clazz, rs)).isEmpty()) break block5;
                t = result.get(0);
            }
            catch (SQLException e) {
                try {
                    throw new DBOperationException(e);
                }
                catch (Throwable throwable) {
                    SQLBuilder.close(conn, ps, rs);
                    throw throwable;
                }
            }
            SQLBuilder.close(conn, ps, rs);
            return t;
        }
        SQLBuilder.close(conn, ps, rs);
        return null;
    }

    protected <T> T selectByPkWithCache(DB db, Number pk, Class<T> clazz, boolean useCache) {
        T data = null;
        if (this.isCacheAvailable(clazz, useCache)) {
            data = this.primaryCache.get(db, pk);
            if (data == null && (data = (T)this._selectByPk(db, pk, clazz)) != null) {
                this.primaryCache.put(db, pk, data);
            }
        } else {
            data = this._selectByPk(db, pk, clazz);
        }
        return data;
    }

    private <T> List<T> _selectGlobalByPks(Connection conn, Class<T> clazz, Number[] pks) {
        List<Object> result = new ArrayList(1);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = SQLBuilder.buildSelectByPks(clazz, -1, pks);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(clazz, rs);
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(null, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(null, ps, rs);
        return result;
    }

    private <T> Map<Number, T> _selectGlobalByPksWithMap(Connection conn, Class<T> clazz, Number[] pks) {
        Map<Object, Object> result = new HashMap();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = SQLBuilder.buildSelectByPks(clazz, -1, pks);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.buildResultObjectAsMap(clazz, rs);
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(null, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(null, ps, rs);
        return result;
    }

    protected <T> List<T> selectGlobalByPksWithCache(Connection conn, String clusterName, Class<T> clazz, Number[] pks, boolean useCache) {
        List<Object> result = new ArrayList();
        if (pks == null || pks.length == 0) {
            return result;
        }
        if (this.isCacheAvailable(clazz, useCache)) {
            String tableName = ReflectUtil.getTableName(clazz);
            List hitResult = this.primaryCache.getGlobal(clusterName, tableName, pks);
            if (hitResult != null && !hitResult.isEmpty()) {
                if (hitResult.size() == pks.length) {
                    result = hitResult;
                } else {
                    try {
                        Map hitMap = this._getPkValues(hitResult);
                        ArrayList<Number> noHitPkList = new ArrayList<Number>();
                        for (Number pk : pks) {
                            if (hitMap.get(pk) != null) continue;
                            noHitPkList.add(pk);
                        }
                        Number[] noHitPks = noHitPkList.toArray(new Number[noHitPkList.size()]);
                        Map<Number, T> noHitMap = this._selectGlobalByPksWithMap(conn, clazz, noHitPks);
                        if (!noHitMap.isEmpty()) {
                            this.primaryCache.putGlobal(clusterName, tableName, noHitMap);
                        }
                        for (Number pk : pks) {
                            if (hitMap.get(pk) != null) {
                                result.add(hitMap.get(pk));
                                continue;
                            }
                            result.add(noHitMap.get(pk));
                        }
                    }
                    catch (Exception e) {
                        result = this._selectGlobalByPks(conn, clazz, pks);
                    }
                }
            } else {
                result = this._selectGlobalByPks(conn, clazz, pks);
                this.primaryCache.putGlobal(clusterName, tableName, result);
            }
        } else {
            result = this._selectGlobalByPks(conn, clazz, pks);
        }
        return result;
    }

    private <T> List<T> _selectByPks(DB db, Class<T> clazz, Number[] pks) {
        List<Object> result = new ArrayList(1);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = db.getDatasource().getConnection();
            String sql = SQLBuilder.buildSelectByPks(clazz, db.getTableIndex(), pks);
            long begin = System.currentTimeMillis();
            ps = conn.prepareStatement(sql);
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            rs = ps.executeQuery();
            result = SQLBuilder.buildResultObject(clazz, rs);
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(conn, ps, rs);
        return result;
    }

    private <T> Map<Number, T> selectByPksWithMap(DB db, Class<T> clazz, Number[] pks) {
        Map<Object, Object> result = new HashMap();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = db.getDatasource().getConnection();
            String sql = SQLBuilder.buildSelectByPks(clazz, db.getTableIndex(), pks);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            result = SQLBuilder.buildResultObjectAsMap(clazz, rs);
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(conn, ps, rs);
        return result;
    }

    protected <T> List<T> selectByPksWithCache(DB db, Class<T> clazz, Number[] pks, boolean useCache) {
        List<Object> result = new ArrayList();
        if (pks.length == 0 || pks == null) {
            return result;
        }
        if (this.isCacheAvailable(clazz, useCache)) {
            List hitResult = this.primaryCache.get(db, pks);
            if (hitResult != null && !hitResult.isEmpty()) {
                if (hitResult.size() == pks.length) {
                    result = hitResult;
                } else {
                    try {
                        Map hitMap = this._getPkValues(hitResult);
                        ArrayList<Number> noHitPkList = new ArrayList<Number>();
                        for (Number pk : pks) {
                            if (hitMap.get(pk) != null) continue;
                            noHitPkList.add(pk);
                        }
                        Number[] noHitPks = noHitPkList.toArray(new Number[noHitPkList.size()]);
                        Map<Number, T> noHitMap = this.selectByPksWithMap(db, clazz, noHitPks);
                        if (!noHitMap.isEmpty()) {
                            this.primaryCache.put(db, noHitMap);
                        }
                        for (Number pk : pks) {
                            if (hitMap.get(pk) != null) {
                                result.add(hitMap.get(pk));
                                continue;
                            }
                            result.add(noHitMap.get(pk));
                        }
                    }
                    catch (Exception e) {
                        result = this._selectByPks(db, clazz, pks);
                    }
                }
            } else {
                result = this._selectByPks(db, clazz, pks);
                this.primaryCache.put(db, pks, result);
            }
        } else {
            result = this._selectByPks(db, clazz, pks);
        }
        return result;
    }

    protected List<Map<String, Object>> selectGlobalBySql(Connection conn, SQL sql) {
        ArrayList<Map<String, Object>> result = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = SQLBuilder.buildSelectBySqlGlobal(conn, sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(rs);
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(null, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(null, ps, rs);
        return result;
    }

    protected List<Map<String, Object>> selectBySql(DB db, SQL sql) {
        ArrayList<Map<String, Object>> result = new ArrayList();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = db.getDatasource().getConnection();
            ps = SQLBuilder.buildSelectBySql(conn, sql, db.getTableIndex());
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(rs);
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(conn, ps, rs);
        return result;
    }

    protected <T> List<T> selectGlobalByQuery(Connection conn, IQuery query, Class<T> clazz) {
        List<Object> result = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = SQLBuilder.buildSelectByQuery(clazz, -1, query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(clazz, rs);
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(null, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(null, ps, rs);
        return result;
    }

    protected <T> List<T> selectByQuery(DB db, IQuery query, Class<T> clazz) {
        List<Object> result = new ArrayList();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = db.getDatasource().getConnection();
            String sql = SQLBuilder.buildSelectByQuery(clazz, db.getTableIndex(), query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(clazz, rs);
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(conn, ps, rs);
        return result;
    }

    protected <T> Number[] selectGlobalPksByQuery(Connection conn, IQuery query, Class<T> clazz) {
        ArrayList<Number> result = new ArrayList<Number>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = SQLBuilder.buildSelectPkByQuery(clazz, -1, query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            while (rs.next()) {
                result.add((Number)rs.getObject(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(null, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(null, ps, rs);
        return result.toArray(new Number[result.size()]);
    }

    protected <T> Number[] selectPksByQuery(DB db, IQuery query, Class<T> clazz) {
        ArrayList<Number> result = new ArrayList<Number>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = db.getDatasource().getConnection();
            String sql = SQLBuilder.buildSelectPkByQuery(clazz, db.getTableIndex(), query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            while (rs.next()) {
                result.add((Number)rs.getObject(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn, ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(conn, ps, rs);
        return result.toArray(new Number[result.size()]);
    }

    private <T> Map<Number, T> _getPkValues(List<T> entities) {
        HashMap<Number, T> map = new HashMap<Number, T>();
        Number pkValue = null;
        for (T entity : entities) {
            pkValue = ReflectUtil.getPkValue(entity);
            map.put(pkValue, entity);
        }
        return map;
    }

    @Override
    public IDBCluster getDBCluster() {
        return this.dbCluster;
    }

    @Override
    public void setDBCluster(IDBCluster dbCluster) {
        this.dbCluster = dbCluster;
    }

    @Override
    public void setPrimaryCache(IPrimaryCache primaryCache) {
        this.primaryCache = primaryCache;
    }

    @Override
    public IPrimaryCache getPrimaryCache() {
        return this.primaryCache;
    }

    @Override
    public void setSecondCache(ISecondCache secondCache) {
        this.secondCache = secondCache;
    }

    @Override
    public ISecondCache getSecondCache() {
        return this.secondCache;
    }
}

