/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pinus4j.api.SQL;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.datalayer.IGlobalSlaveQuery;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJdbcSlaveQueryImpl
extends AbstractJdbcQuery
implements IGlobalSlaveQuery {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalJdbcSlaveQueryImpl.class);

    @Override
    public <T> T findGlobalOneByQueryFromSlave(IQuery query, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        List<T> entities = this.findGlobalByQueryFromSlave(query, clusterName, clazz, useCache, slave);
        if (entities.isEmpty()) {
            return null;
        }
        return entities.get(0);
    }

    @Override
    public Number getGlobalCountFromSlave(String clusterName, Class<?> clazz, boolean useCache, EnumDBMasterSlave slave) {
        DBInfo dbConnInfo = null;
        try {
            dbConnInfo = this.dbCluster.getSlaveGlobalDbConn(clusterName, slave);
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        long count = this.selectGlobalCountWithCache(dbConnInfo, clusterName, clazz, useCache).longValue();
        return count;
    }

    @Override
    public Number getGlobalCountFromSlave(IQuery query, String clusterName, Class<?> clazz, EnumDBMasterSlave slave) {
        DBInfo globalConnection;
        try {
            globalConnection = this.dbCluster.getSlaveGlobalDbConn(clusterName, slave);
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        long count = this.selectGlobalCount(query, globalConnection, clusterName, clazz).longValue();
        return count;
    }

    @Override
    public <T> T findGlobalByPkFromSlave(Number pk, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        T t;
        Connection conn = null;
        try {
            conn = this.dbCluster.getSlaveGlobalDbConn(clusterName, slave).getDatasource().getConnection();
            t = this.selectByPkWithCache(conn, clusterName, pk, clazz, useCache);
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return t;
    }

    @Override
    public <T> List<T> findGlobalByPksFromSlave(String clusterName, Class<T> clazz, EnumDBMasterSlave slave, Number ... pks) {
        return this.findGlobalByPksFromSlave(clusterName, clazz, slave, true, pks);
    }

    @Override
    public <T> List<T> findGlobalByPksFromSlave(String clusterName, Class<T> clazz, EnumDBMasterSlave slave, boolean useCache, Number ... pks) {
        ArrayList<T> result = new ArrayList<T>();
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getSlaveGlobalDbConn(clusterName, slave);
            conn = globalConnection.getDatasource().getConnection();
            result.addAll(this.selectGlobalByPksWithCache(conn, clusterName, clazz, pks, useCache));
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return result;
    }

    @Override
    public <T> List<T> findGlobalByPkListFromSlave(List<? extends Number> pks, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        ArrayList<T> result = new ArrayList<T>();
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getSlaveGlobalDbConn(clusterName, slave);
            conn = globalConnection.getDatasource().getConnection();
            result.addAll(this.selectGlobalByPksWithCache(conn, clusterName, clazz, pks.toArray(new Number[pks.size()]), useCache));
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return result;
    }

    @Override
    public List<Map<String, Object>> findGlobalBySqlFromSlave(SQL sql, String clusterName, EnumDBMasterSlave slave) {
        List<Map<String, Object>> list;
        Connection conn = null;
        try {
            List<Map<String, Object>> result;
            DBInfo slaveGlobal = this.dbCluster.getSlaveGlobalDbConn(clusterName, slave);
            conn = slaveGlobal.getDatasource().getConnection();
            list = result = this.selectGlobalBySql(conn, sql);
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return list;
    }

    @Override
    public <T> List<T> findGlobalByQueryFromSlave(IQuery query, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        List<T> list;
        Connection conn = null;
        try {
            DBInfo globalConnection = this.dbCluster.getSlaveGlobalDbConn(clusterName, slave);
            conn = globalConnection.getDatasource().getConnection();
            List<T> result = null;
            String tableName = ReflectUtil.getTableName(clazz);
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                result = this.secondCache.getGlobal(query, clusterName, tableName);
            }
            if (result == null || result.isEmpty()) {
                if (this.isCacheAvailable(clazz, useCache)) {
                    Number[] pkValues = this.selectGlobalPksByQuery(conn, query, clazz);
                    result = this.selectGlobalByPksWithCache(conn, clusterName, clazz, pkValues, useCache);
                } else {
                    result = this.selectGlobalByQuery(conn, query, clazz);
                }
                if (this.isSecondCacheAvailable(clazz, useCache)) {
                    this.secondCache.putGlobal(query, clusterName, tableName, result);
                }
            }
            ArrayList<T> filteResult = new ArrayList<T>(result.size());
            if (query.hasQueryFields()) {
                for (Object obj : result) {
                    filteResult.add(ReflectUtil.cloneWithGivenField(obj, query.getFields()));
                }
                result = filteResult;
            }
            list = result;
        }
        catch (Exception e) {
            try {
                throw new DBOperationException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(conn);
                throw throwable;
            }
        }
        SQLBuilder.close(conn);
        return list;
    }
}

