/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cluster.DB;
import org.pinus4j.datalayer.IShardingMasterQuery;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingJdbcMasterQueryImpl
extends AbstractJdbcQuery
implements IShardingMasterQuery {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingJdbcMasterQueryImpl.class);

    @Override
    public Number getCountFromMaster(Class<?> clazz, boolean useCache) {
        List<DB> dbs = this.dbCluster.getAllMasterShardingDB(clazz);
        long count = 0L;
        for (DB db : dbs) {
            count += this.selectCountWithCache(db, clazz, useCache).longValue();
        }
        return count;
    }

    @Override
    public Number getCountFromMaster(Class<?> clazz, IQuery query) {
        List<DB> dbs = this.dbCluster.getAllMasterShardingDB(clazz);
        long count = 0L;
        for (DB db : dbs) {
            count += this.selectCount(db, clazz, query).longValue();
        }
        return count;
    }

    @Override
    public Number getCountFromMaster(IShardingKey<?> shardingKey, Class<?> clazz, boolean useCache) {
        DB db = this._getDbFromMaster(clazz, shardingKey);
        return this.selectCountWithCache(db, clazz, useCache);
    }

    @Override
    public Number getCountFromMaster(IQuery query, IShardingKey<?> shardingKey, Class<?> clazz) {
        DB db = this._getDbFromMaster(clazz, shardingKey);
        return this.selectCount(db, clazz, query);
    }

    @Override
    public <T> T findByPkFromMaster(Number pk, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        DB db = this._getDbFromMaster(clazz, shardingKey);
        return this.selectByPkWithCache(db, pk, clazz, useCache);
    }

    @Override
    public <T> T findOneByQueryFromMaster(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        List<T> entities = this.findByQueryFromMaster(query, shardingKey, clazz, useCache);
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() > 1) {
            throw new DBOperationException("\u67e5\u8be2\u7ed3\u679c\u5927\u4e8e1\u6761\u8bb0\u5f55");
        }
        try {
            if (query.hasQueryFields()) {
                Object obj = ReflectUtil.cloneWithGivenField(entities.get(0), query.getFields());
                return (T)obj;
            }
            T obj = entities.get(0);
            return obj;
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public <T> List<T> findByPksFromMaster(IShardingKey<?> shardingKey, Class<T> clazz, Number ... pks) {
        return this.findByPksFromMaster(shardingKey, clazz, true, pks);
    }

    @Override
    public <T> List<T> findByPksFromMaster(IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, Number ... pks) {
        DB db = this._getDbFromMaster(clazz, shardingKey);
        return this.selectByPksWithCache(db, clazz, pks, useCache);
    }

    @Override
    public <T> List<T> findByPkListFromMaster(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        DB db = this._getDbFromMaster(clazz, shardingKey);
        return this.selectByPksWithCache(db, clazz, pks.toArray(new Number[pks.size()]), useCache);
    }

    @Override
    @Deprecated
    public <T> List<T> findByShardingPairFromMaster(List<IShardingKey<?>> shardingValues, Class<T> clazz, Number ... pks) {
        if (shardingValues.size() != pks.length) {
            throw new DBOperationException("\u5206\u5e93\u5206\u8868\u5217\u8868\u548c\u4e3b\u952e\u6570\u91cf\u4e0d\u7b49");
        }
        ArrayList<Object> result = new ArrayList<Object>(pks.length);
        IShardingKey<?> shardingKey = null;
        Number pk = null;
        DB db = null;
        Object data = null;
        for (int i = 0; i < pks.length; ++i) {
            shardingKey = shardingValues.get(i);
            pk = pks[i];
            db = this._getDbFromMaster(clazz, shardingKey);
            data = this.selectByPkWithCache(db, pk, clazz, true);
            if (data == null) continue;
            result.add(data);
        }
        return result;
    }

    @Override
    public <T> List<T> findByShardingPairFromMaster(List<? extends Number> pks, List<IShardingKey<?>> shardingValues, Class<T> clazz, boolean useCache) {
        if (shardingValues.size() != pks.size()) {
            throw new DBOperationException("\u5206\u5e93\u5206\u8868\u5217\u8868\u548c\u4e3b\u952e\u6570\u91cf\u4e0d\u7b49");
        }
        ArrayList<Object> result = new ArrayList<Object>(pks.size());
        IShardingKey<?> shardingKey = null;
        Number pk = null;
        DB db = null;
        Object data = null;
        for (int i = 0; i < pks.size(); ++i) {
            shardingKey = shardingValues.get(i);
            pk = pks.get(i);
            db = this._getDbFromMaster(clazz, shardingKey);
            data = this.selectByPkWithCache(db, pk, clazz, useCache);
            if (data == null) continue;
            result.add(data);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> findBySqlFromMaster(SQL sql, IShardingKey<?> shardingKey) {
        DB next = null;
        for (String tableName : sql.getTableNames()) {
            DB cur = this._getDbFromMaster(tableName, shardingKey);
            if (next != null && cur != next) {
                throw new DBOperationException("the tables in sql maybe not at the same database");
            }
            next = cur;
        }
        List<Map<String, Object>> result = this.selectBySql(next, sql);
        return result;
    }

    @Override
    public <T> List<T> findByQueryFromMaster(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        DB db = this._getDbFromMaster(clazz, shardingKey);
        List<T> result = null;
        if (this.isSecondCacheAvailable(clazz, useCache)) {
            result = this.secondCache.get(query, db);
        }
        if (result == null || result.isEmpty()) {
            if (this.isCacheAvailable(clazz, useCache)) {
                Number[] pkValues = this.selectPksByQuery(db, query, clazz);
                result = this.selectByPksWithCache(db, clazz, pkValues, useCache);
            } else {
                result = this.selectByQuery(db, query, clazz);
            }
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                this.secondCache.put(query, db, result);
            }
        }
        ArrayList<T> filteResult = new ArrayList<T>(result.size());
        if (query.hasQueryFields()) {
            for (T obj : result) {
                try {
                    filteResult.add(ReflectUtil.cloneWithGivenField(obj, query.getFields()));
                }
                catch (Exception e) {
                    throw new DBOperationException(e);
                }
            }
            result = filteResult;
        }
        return result;
    }

    private DB _getDbFromMaster(Class<?> clazz, IShardingKey<?> shardingKey) {
        String tableName = ReflectUtil.getTableName(clazz);
        return this._getDbFromMaster(tableName, shardingKey);
    }

    private DB _getDbFromMaster(String tableName, IShardingKey<?> shardingKey) {
        DB db = null;
        try {
            db = this.dbCluster.selectDbFromMaster(tableName, shardingKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + db + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        return db;
    }
}

