/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.SQL;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cluster.DB;
import org.pinus4j.datalayer.IShardingSlaveQuery;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingJdbcSlaveQueryImpl
extends AbstractJdbcQuery
implements IShardingSlaveQuery {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingJdbcSlaveQueryImpl.class);

    @Override
    public Number getCountFromSlave(IShardingKey<?> shardingKey, Class<?> clazz, boolean useCache, EnumDBMasterSlave slave) {
        DB db = this._getDbFromSlave(clazz, shardingKey, slave);
        return this.selectCountWithCache(db, clazz, useCache);
    }

    @Override
    public <T> T findByPkFromSlave(Number pk, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        DB db = this._getDbFromSlave(clazz, shardingKey, slave);
        return this.selectByPkWithCache(db, pk, clazz, useCache);
    }

    @Override
    public <T> T findOneByQueryFromSlave(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        List<T> entities = this.findByQueryFromSlave(query, shardingKey, clazz, useCache, slave);
        if (entities.isEmpty()) {
            return null;
        }
        return entities.get(0);
    }

    @Override
    public <T> List<T> findByPksFromSlave(IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave slave, Number ... pks) {
        return this.findByPksFromSlave(shardingKey, clazz, slave, true, pks);
    }

    @Override
    public <T> List<T> findByPksFromSlave(IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave slave, boolean useCache, Number ... pks) {
        DB db = this._getDbFromSlave(clazz, shardingKey, slave);
        return this.selectByPksWithCache(db, clazz, pks, true);
    }

    @Override
    public <T> List<T> findByPkListFromSlave(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        DB db = this._getDbFromSlave(clazz, shardingKey, slave);
        return this.selectByPksWithCache(db, clazz, pks.toArray(new Number[pks.size()]), useCache);
    }

    @Override
    @Deprecated
    public <T> List<T> findByShardingPairFromSlave(List<IShardingKey<?>> shardingValues, Class<T> clazz, EnumDBMasterSlave slave, Number ... pks) {
        if (shardingValues.size() != pks.length) {
            throw new DBOperationException("\u5206\u5e93\u5206\u8868\u5217\u8868\u548c\u4e3b\u952e\u6570\u91cf\u4e0d\u7b49");
        }
        ArrayList<Object> result = new ArrayList<Object>(pks.length);
        IShardingKey<?> shardingKey = null;
        Number pk = null;
        DB db = null;
        Object data = null;
        for (int i = 0; i < pks.length; ++i) {
            shardingKey = shardingValues.get(i);
            pk = pks[i];
            db = this._getDbFromSlave(clazz, shardingKey, slave);
            data = this.selectByPkWithCache(db, pk, clazz, true);
            if (data == null) continue;
            result.add(data);
        }
        return result;
    }

    @Override
    public <T> List<T> findByShardingPairFromSlave(List<? extends Number> pks, List<IShardingKey<?>> shardingValues, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        if (shardingValues.size() != pks.size()) {
            throw new DBOperationException("\u5206\u5e93\u5206\u8868\u5217\u8868\u548c\u4e3b\u952e\u6570\u91cf\u4e0d\u7b49");
        }
        ArrayList<Object> result = new ArrayList<Object>(pks.size());
        IShardingKey<?> shardingKey = null;
        Number pk = null;
        DB db = null;
        Object data = null;
        for (int i = 0; i < pks.size(); ++i) {
            shardingKey = shardingValues.get(i);
            pk = pks.get(i);
            db = this._getDbFromSlave(clazz, shardingKey, slave);
            data = this.selectByPkWithCache(db, pk, clazz, useCache);
            if (data == null) continue;
            result.add(data);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> findBySqlFromSlave(SQL sql, IShardingKey<?> shardingKey, EnumDBMasterSlave slave) {
        DB next = null;
        for (String tableName : sql.getTableNames()) {
            DB cur = this._getDbFromSlave(tableName, shardingKey, slave);
            if (next != null && cur != next) {
                throw new DBOperationException("the tables in sql maybe not at the same database");
            }
            next = cur;
        }
        List<Map<String, Object>> result = this.selectBySql(next, sql);
        return result;
    }

    @Override
    public <T> List<T> findByQueryFromSlave(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        DB db = this._getDbFromSlave(clazz, shardingKey, slave);
        List<T> result = null;
        if (this.isSecondCacheAvailable(clazz, useCache)) {
            result = this.secondCache.get(query, db);
        }
        if (result == null || result.isEmpty()) {
            if (this.isCacheAvailable(clazz, useCache)) {
                Number[] pkValues = this.selectPksByQuery(db, query, clazz);
                result = this.selectByPksWithCache(db, clazz, pkValues, useCache);
            } else {
                result = this.selectByQuery(db, query, clazz);
            }
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                this.secondCache.put(query, db, result);
            }
        }
        ArrayList<T> filteResult = new ArrayList<T>(result.size());
        if (query.hasQueryFields()) {
            for (T obj : result) {
                try {
                    filteResult.add(ReflectUtil.cloneWithGivenField(obj, query.getFields()));
                }
                catch (Exception e) {
                    throw new DBOperationException(e);
                }
            }
            result = filteResult;
        }
        return result;
    }

    private DB _getDbFromSlave(Class<?> clazz, IShardingKey<?> shardingKey, EnumDBMasterSlave slave) {
        String tableName = ReflectUtil.getTableName(clazz);
        DB db = null;
        try {
            db = this.dbCluster.selectDbFromSlave(tableName, shardingKey, slave);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + db + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        return db;
    }

    private DB _getDbFromSlave(String tableName, IShardingKey<?> shardingKey, EnumDBMasterSlave slave) {
        DB db = null;
        try {
            db = this.dbCluster.selectDbFromSlave(tableName, shardingKey, slave);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + db + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        return db;
    }
}

