/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.cluster.DB;
import org.pinus4j.datalayer.IShardingUpdate;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.jdbc.AbstractJdbcUpdate;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingJdbcUpdateImpl
extends AbstractJdbcUpdate
implements IShardingUpdate {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingJdbcUpdateImpl.class);

    public Number save(Object entity, IShardingKey shardingKey) {
        Class<?> clazz = entity.getClass();
        String tableName = ReflectUtil.getTableName(clazz);
        boolean isCheckPrimaryKey = true;
        Number pk = ReflectUtil.getPkValue(entity);
        if (pk == null || pk.intValue() == 0) {
            isCheckPrimaryKey = false;
            pk = this.idGenerator.genClusterUniqueLongId("/pinus/primarykey/" + shardingKey.getClusterName(), tableName);
            try {
                ReflectUtil.setPkValue(entity, pk);
            }
            catch (Exception e) {
                throw new DBOperationException(e);
            }
        }
        if (isCheckPrimaryKey) {
            this.idGenerator.checkAndSetPrimaryKey(pk.longValue(), shardingKey.getClusterName(), tableName);
        }
        DB db = this._getDbFromMaster(tableName, shardingKey);
        ArrayList<Object> entities = new ArrayList<Object>(1);
        entities.add(entity);
        Connection conn = null;
        try {
            conn = db.getDatasource().getConnection();
            this._saveBatch(conn, entities, db.getTableIndex());
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.incrCount(db, 1L);
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(db);
            }
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
        finally {
            SQLBuilder.close(conn);
        }
        return pk;
    }

    @Override
    public Number[] saveBatch(List<? extends Object> entities, IShardingKey<?> shardingKey) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = ReflectUtil.getTableName(clazz);
        DB db = this._getDbFromMaster(tableName, shardingKey);
        int entitySize = entities.size();
        Number[] pks = new Number[entitySize];
        boolean isCheckPrimaryKey = true;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>(entitySize);
        Number pk = null;
        Number maxPk = 0;
        Object entity = null;
        for (int i = 0; i < entitySize; ++i) {
            entity = entities.get(i);
            pk = ReflectUtil.getPkValue(entity);
            if (pk == null || pk.longValue() == 0L) {
                map.put(i, entity);
                continue;
            }
            pks[i] = pk;
            maxPk = pk.intValue() > maxPk ? (Number)pk : (Number)maxPk;
        }
        if (!map.isEmpty()) {
            isCheckPrimaryKey = false;
            int[] newPks = this.idGenerator.genClusterUniqueIntIdBatch("/pinus/primarykey/" + db.getClusterName(), tableName, map.size(), ((Number)maxPk).longValue());
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                int pos = ((Number)entry.getKey()).intValue();
                try {
                    ReflectUtil.setPkValue(entities.get(pos), newPks[i]);
                }
                catch (Exception e) {
                    throw new DBOperationException(e);
                }
                pks[pos] = newPks[i];
                ++i;
            }
        }
        if (isCheckPrimaryKey) {
            this.idGenerator.checkAndSetPrimaryKey(((Number)maxPk).longValue(), db.getClusterName(), tableName);
        }
        Connection conn = null;
        try {
            conn = db.getDatasource().getConnection();
            this._saveBatch(conn, entities, db.getTableIndex());
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.incrCount(db, pks.length);
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(db);
            }
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
        finally {
            SQLBuilder.close(conn);
        }
        return pks;
    }

    @Override
    public void update(Object entity, IShardingKey<?> shardingKey) {
        ArrayList<Object> entities = new ArrayList<Object>();
        entities.add(entity);
        this.updateBatch(entities, shardingKey);
    }

    @Override
    public void updateBatch(List<? extends Object> entities, IShardingKey<?> shardingKey) {
        Class<?> clazz = entities.get(0).getClass();
        String talbeName = ReflectUtil.getTableName(clazz);
        DB db = this._getDbFromMaster(talbeName, shardingKey);
        Connection conn = null;
        try {
            conn = db.getDatasource().getConnection();
            this._updateBatch(conn, entities, db.getTableIndex());
            if (this.isCacheAvailable(clazz)) {
                ArrayList<Number> pks = new ArrayList<Number>(entities.size());
                for (Object object : entities) {
                    pks.add(ReflectUtil.getPkValue(object));
                }
                this.primaryCache.remove(db, pks);
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(db);
            }
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
        finally {
            SQLBuilder.close(conn);
        }
    }

    @Override
    public void removeByPk(Number pk, IShardingKey<?> shardingKey, Class<?> clazz) {
        ArrayList<Number> pks = new ArrayList<Number>(1);
        pks.add(pk);
        this.removeByPks(pks, shardingKey, clazz);
    }

    @Override
    public void removeByPks(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<?> clazz) {
        String talbeName = ReflectUtil.getTableName(clazz);
        DB db = this._getDbFromMaster(talbeName, shardingKey);
        Connection conn = null;
        try {
            conn = db.getDatasource().getConnection();
            this._removeByPks(conn, pks, clazz, db.getTableIndex());
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.remove(db, pks);
                this.primaryCache.decrCount(db, pks.size());
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(db);
            }
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
        finally {
            SQLBuilder.close(conn);
        }
    }

    private DB _getDbFromMaster(String tableName, IShardingKey<?> shardingKey) {
        DB db = null;
        try {
            db = this.dbCluster.selectDbFromMaster(tableName, shardingKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + db + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        return db;
    }
}

