/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.generator;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.pinus4j.generator.IDBGenerator;
import org.pinus4j.generator.annotations.DateTime;
import org.pinus4j.generator.annotations.Field;
import org.pinus4j.generator.annotations.Index;
import org.pinus4j.generator.annotations.Indexes;
import org.pinus4j.generator.annotations.PrimaryKey;
import org.pinus4j.generator.annotations.Table;
import org.pinus4j.generator.annotations.UpdateTime;
import org.pinus4j.generator.beans.DBIndex;
import org.pinus4j.generator.beans.DBTable;
import org.pinus4j.generator.beans.DBTableColumn;
import org.pinus4j.generator.beans.DataTypeBind;
import org.pinus4j.utils.ReflectUtil;
import org.pinus4j.utils.StringUtils;

public abstract class AbstractDBGenerator
implements IDBGenerator {
    private final ClassLoader classloader = Thread.currentThread().getContextClassLoader();

    @Override
    public List<DBTable> scanEntity(String scanPackage) throws IOException, ClassNotFoundException {
        ArrayList<DBTable> tables = new ArrayList<DBTable>();
        String pkgDirName = scanPackage.replace(".", "/");
        Enumeration<URL> dirs = this.classloader.getResources(pkgDirName);
        URL url = null;
        while (dirs.hasMoreElements()) {
            url = dirs.nextElement();
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                String filePath = URLDecoder.decode(url.getFile(), "utf-8");
                this.addClassesByFile(tables, scanPackage, filePath);
                continue;
            }
            if (!protocol.equals("jar")) continue;
            JarFile jar = null;
            jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(pkgDirName) || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(scanPackage.length() + 1, name.length() - 6).replace("/", ".");
                Class<?> tableClass = this.classloader.loadClass(scanPackage + "." + className);
                if (tableClass.getAnnotation(Table.class) == null) continue;
                tables.add(this.converTo(tableClass));
            }
        }
        return tables;
    }

    private void addClassesByFile(List<DBTable> tables, String packageName, String packagePath) throws ClassNotFoundException {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                this.addClassesByFile(tables, packageName + "." + file.getName(), file.getAbsolutePath());
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            Class<?> tableClass = this.classloader.loadClass(packageName + "." + className);
            if (tableClass.getAnnotation(Table.class) == null) continue;
            tables.add(this.converTo(tableClass));
        }
    }

    protected DBTable converTo(Class<?> defClass) {
        Class<?> clazz;
        if (defClass == null) {
            throw new IllegalArgumentException("\u88ab\u8f6c\u5316\u7684Java\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            clazz = defClass.newInstance().getClass();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Table annoTable = clazz.getAnnotation(Table.class);
        if (annoTable == null) {
            throw new IllegalArgumentException(clazz + "\u65e0\u6cd5\u8f6c\u5316\u4e3a\u6570\u636e\u5e93\uff0c\u8bf7\u4f7f\u7528@Table\u6ce8\u89e3");
        }
        String tableName = ReflectUtil.getTableName(clazz);
        DBTable table = new DBTable(tableName.toLowerCase());
        String cluster = annoTable.cluster();
        if (StringUtils.isBlank(cluster)) {
            throw new IllegalArgumentException(clazz + " @Table\u7684cluster\u4e0d\u80fd\u4e3a\u7a7a");
        }
        table.setCluster(cluster);
        String shardingBy = annoTable.shardingBy();
        table.setShardingBy(shardingBy);
        int shardingNum = annoTable.shardingNum();
        table.setShardingNum(shardingNum);
        AbstractDBGenerator._parseDBIndex(table, clazz);
        DBTableColumn column = null;
        Field dbField = null;
        PrimaryKey pk = null;
        UpdateTime updateTime = null;
        DateTime datetime = null;
        boolean isSetPrimaryKey = false;
        for (java.lang.reflect.Field f : clazz.getDeclaredFields()) {
            column = new DBTableColumn();
            datetime = f.getAnnotation(DateTime.class);
            if (datetime != null) {
                if (f.getType() != Date.class) {
                    throw new IllegalArgumentException(clazz + " " + f.getName() + " " + f.getType() + " \u65e0\u6cd5\u8f6c\u5316\u4e3a\u65e5\u671f\u5b57\u6bb5");
                }
                column.setField(f.getName());
                column.setType(DataTypeBind.getEnum(f.getType()).getDBType());
                column.setHasDefault(datetime.hasDefault());
                if (column.isHasDefault()) {
                    column.setDefaultValue(DataTypeBind.getEnum(f.getType()).getDefaultValue());
                }
                column.setComment(datetime.comment());
                table.addColumn(column);
            }
            if ((updateTime = f.getAnnotation(UpdateTime.class)) != null) {
                if (f.getType() != Timestamp.class) {
                    throw new IllegalArgumentException(clazz + " " + f.getName() + " " + f.getType() + " \u65e0\u6cd5\u8f6c\u5316\u4e3a\u65f6\u95f4\u6233\u5b57\u6bb5");
                }
                column.setField(f.getName());
                column.setType(DataTypeBind.UPDATETIME.getDBType());
                column.setHasDefault(true);
                column.setDefaultValue(DataTypeBind.UPDATETIME.getDefaultValue());
                column.setComment(updateTime.comment());
                table.addColumn(column);
            }
            if ((dbField = f.getAnnotation(Field.class)) != null) {
                if (f.getType() == Timestamp.class) {
                    throw new IllegalArgumentException(clazz + " " + f.getName() + "\u5e94\u8be5\u662f\u65f6\u95f4\u6233\u7c7b\u578b\uff0c\u5fc5\u987b\u4f7f\u7528@UpdateTime\u6807\u6ce8");
                }
                String fieldName = f.getName();
                boolean isCanNull = dbField.isCanNull();
                int length = AbstractDBGenerator._getLength(f, dbField);
                boolean hasDefault = dbField.hasDefault();
                column.setField(fieldName);
                column.setType(DataTypeBind.getEnum(f.getType()).getDBType());
                column.setCanNull(isCanNull);
                column.setLength(length);
                column.setHasDefault(hasDefault);
                column.setComment(dbField.comment());
                if (column.isHasDefault()) {
                    column.setDefaultValue(DataTypeBind.getEnum(f.getType()).getDefaultValue());
                }
                if (column.getType().equals(DataTypeBind.STRING.getDBType()) && column.getLength() > 4000) {
                    column.setType(DataTypeBind.TEXT.getDBType());
                    column.setHasDefault(false);
                    column.setLength(0);
                    column.setDefaultValue(DataTypeBind.TEXT.getDefaultValue());
                }
                if (column.getType().equals(DataTypeBind.BOOL.getDBType())) {
                    column.setLength(1);
                }
                table.addColumn(column);
            }
            if ((pk = f.getAnnotation(PrimaryKey.class)) == null) continue;
            if (isSetPrimaryKey) {
                throw new IllegalArgumentException(clazz + "\u88ab\u8f6c\u5316\u7684Java\u5bf9\u8c61\u4e0d\u80fd\u6709\u591a\u4e2a@PrimaryKey\u6ce8\u89e3");
            }
            column.setField(f.getName());
            DataTypeBind dbType = DataTypeBind.getEnum(f.getType());
            column.setType(dbType.getDBType());
            column.setPrimaryKey(true);
            column.setAutoIncrement(false);
            column.setCanNull(false);
            int length = AbstractDBGenerator._getDbLength(dbType);
            column.setLength(length);
            column.setDefaultValue(null);
            isSetPrimaryKey = true;
            column.setComment(pk.comment());
            table.addColumn(column);
        }
        if (table.getColumns().isEmpty()) {
            throw new IllegalStateException(clazz + "\u88ab\u8f6c\u5316\u7684java\u5bf9\u8c61\u6ca1\u6709\u5305\u542b\u4efb\u4f55\u5217\u5c5e\u6027" + defClass);
        }
        return table;
    }

    private static void _parseDBIndex(DBTable table, Class<?> clazz) {
        Indexes annoIndexes = clazz.getAnnotation(Indexes.class);
        if (annoIndexes == null) {
            return;
        }
        Index[] indexes = annoIndexes.value();
        if (indexes == null || indexes.length <= 0) {
            throw new IllegalArgumentException("\u7d22\u5f15\u6ce8\u89e3\u9519\u8bef, " + clazz);
        }
        DBIndex dbIndex = null;
        for (Index index : indexes) {
            dbIndex = new DBIndex();
            dbIndex.setField(StringUtils.removeBlank(index.field()));
            dbIndex.setUnique(index.isUnique());
            table.addIndex(dbIndex);
        }
    }

    private static int _getLength(java.lang.reflect.Field f, Field af) {
        int length = af.length();
        if (length > 0) {
            return length;
        }
        DataTypeBind dbType = DataTypeBind.getEnum(f.getType());
        return AbstractDBGenerator._getDbLength(dbType);
    }

    private static int _getDbLength(DataTypeBind dbType) {
        int length = 0;
        switch (dbType) {
            case STRING: {
                length = 255;
                break;
            }
            case BYTE: {
                length = 4;
                break;
            }
            case SHORT: {
                length = 6;
                break;
            }
            case INT: {
                length = 11;
                break;
            }
            case LONG: {
                length = 20;
                break;
            }
        }
        return length;
    }
}

