/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.generator;

import org.pinus4j.api.enums.EnumDB;
import org.pinus4j.api.enums.EnumSyncAction;
import org.pinus4j.generator.IDBGenerator;
import org.pinus4j.generator.IDBGeneratorBuilder;
import org.pinus4j.generator.impl.DBMySqlGeneratorImpl;

public class DefaultDBGeneratorBuilder
implements IDBGeneratorBuilder {
    private EnumSyncAction syncAction = EnumSyncAction.CREATE;
    private EnumDB enumDb = EnumDB.MYSQL;

    private DefaultDBGeneratorBuilder() {
    }

    public static IDBGeneratorBuilder valueOf(EnumSyncAction syncAction, EnumDB enumDb) {
        DefaultDBGeneratorBuilder builder = new DefaultDBGeneratorBuilder();
        builder.setSyncAction(syncAction);
        builder.setDBCatalog(enumDb);
        return builder;
    }

    @Override
    public IDBGenerator build() {
        DBMySqlGeneratorImpl dbGenerator = null;
        switch (this.enumDb) {
            case MYSQL: {
                dbGenerator = new DBMySqlGeneratorImpl();
                break;
            }
            default: {
                dbGenerator = new DBMySqlGeneratorImpl();
            }
        }
        dbGenerator.setSyncAction(this.syncAction);
        return dbGenerator;
    }

    public EnumSyncAction getSyncAction() {
        return this.syncAction;
    }

    @Override
    public void setSyncAction(EnumSyncAction syncAction) {
        this.syncAction = syncAction;
    }

    @Override
    public void setDBCatalog(EnumDB enumDb) {
        this.enumDb = enumDb;
    }
}

