/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.generator.beans;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum DataTypeBind {
    BOOL("char", 0),
    BYTE("tinyint", 0),
    CHAR("char", "''"),
    SHORT("smallint", 0),
    INT("int", 0),
    LONG("bigint", 0),
    FLOAT("float", 0.0),
    DOUBLE("double", 0.0),
    STRING("varchar", "''"),
    TEXT("text", null),
    DATETIME("datetime", "'0000-00-00 00:00:00'"),
    UPDATETIME("updatetime", "");

    private String dbType;
    private Object defaultValue;
    private static final Map<String, DataTypeBind> MAP;

    private DataTypeBind(String dbType, Object defaultValue) {
        this.dbType = dbType;
        this.defaultValue = defaultValue;
    }

    public String getDBType() {
        return this.dbType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public static DataTypeBind getEnum(String dbType) {
        return MAP.get(dbType);
    }

    public static DataTypeBind getEnum(Class<?> fieldType) {
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return BOOL;
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return BYTE;
        }
        if (fieldType == Character.TYPE || fieldType == Character.class) {
            return CHAR;
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return SHORT;
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return INT;
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return LONG;
        }
        if (fieldType == Float.TYPE || fieldType == Float.class) {
            return FLOAT;
        }
        if (fieldType == Double.TYPE || fieldType == Double.class) {
            return DOUBLE;
        }
        if (fieldType == String.class) {
            return STRING;
        }
        if (fieldType == Date.class) {
            return DATETIME;
        }
        throw new IllegalStateException("\u65e0\u6cd5\u8bc6\u522b\u7684\u7c7b\u578b" + fieldType);
    }

    static {
        MAP = new HashMap<String, DataTypeBind>(13);
        for (DataTypeBind value : DataTypeBind.values()) {
            MAP.put(value.getDBType(), value);
        }
    }
}

