/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.transaction.TransactionManager;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.IShardingStorageClient;
import org.pinus4j.api.SQL;
import org.pinus4j.api.ShardingKey;
import org.pinus4j.api.enums.EnumDB;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.enums.EnumDbConnectionPoolCatalog;
import org.pinus4j.api.enums.EnumSyncAction;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.QueryImpl;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.cluster.config.IClusterConfig;
import org.pinus4j.cluster.config.impl.XmlClusterConfigImpl;
import org.pinus4j.cluster.impl.AppDBClusterImpl;
import org.pinus4j.cluster.impl.EnvDBClusterImpl;
import org.pinus4j.datalayer.IDataLayerBuilder;
import org.pinus4j.datalayer.IGlobalMasterQuery;
import org.pinus4j.datalayer.IGlobalSlaveQuery;
import org.pinus4j.datalayer.IGlobalUpdate;
import org.pinus4j.datalayer.IShardingMasterQuery;
import org.pinus4j.datalayer.IShardingSlaveQuery;
import org.pinus4j.datalayer.IShardingUpdate;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.exceptions.LoadConfigException;
import org.pinus4j.generator.IIdGenerator;
import org.pinus4j.task.ITask;
import org.pinus4j.task.TaskExecutor;
import org.pinus4j.task.TaskFuture;
import org.pinus4j.transaction.enums.EnumTransactionIsolationLevel;
import org.pinus4j.transaction.impl.BestEffortsOnePCJtaTransactionManager;
import org.pinus4j.utils.CheckUtil;
import org.pinus4j.utils.ReflectUtil;
import org.pinus4j.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingStorageClientImpl
implements IShardingStorageClient {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingStorageClientImpl.class);
    public static IShardingStorageClient instance;
    private EnumDB enumDb = EnumDB.MYSQL;
    private EnumSyncAction syncAction = EnumSyncAction.CREATE;
    private String scanPackage;
    private IIdGenerator idGenerator;
    private IDBCluster dbCluster;
    private TransactionManager txManager;
    private IGlobalUpdate globalUpdater;
    private IGlobalMasterQuery globalMasterQuery;
    private IGlobalSlaveQuery globalSlaveQuery;
    private IShardingUpdate shardingUpdater;
    private IShardingMasterQuery masterQueryer;
    private IShardingSlaveQuery slaveQueryer;

    @Override
    public void init() throws LoadConfigException {
        IClusterConfig clusterConfig = XmlClusterConfigImpl.getInstance();
        EnumDbConnectionPoolCatalog enumDbCpCatalog = clusterConfig.getDbConnectionPoolCatalog();
        switch (enumDbCpCatalog) {
            case APP: {
                this.dbCluster = new AppDBClusterImpl(this.enumDb);
                break;
            }
            case ENV: {
                this.dbCluster = new EnvDBClusterImpl(this.enumDb);
                break;
            }
            default: {
                this.dbCluster = new AppDBClusterImpl(this.enumDb);
            }
        }
        this.dbCluster.setSyncAction(this.syncAction);
        this.dbCluster.setScanPackage(this.scanPackage);
        try {
            this.dbCluster.startup();
        }
        catch (DBClusterException e) {
            throw new RuntimeException(e);
        }
        this.idGenerator = this.dbCluster.getIdGenerator();
        this.txManager = this.dbCluster.getTransactionManager();
        IDataLayerBuilder dataLayerBuilder = this.dbCluster.getDataLayerBuilder();
        this.globalUpdater = dataLayerBuilder.buildGlobalUpdate(this.dbCluster.getIdGenerator());
        this.globalMasterQuery = dataLayerBuilder.buildGlobalMasterQuery();
        this.globalSlaveQuery = dataLayerBuilder.buildGlobalSlaveQuery();
        this.shardingUpdater = dataLayerBuilder.buildShardingUpdate(this.dbCluster.getIdGenerator());
        this.masterQueryer = dataLayerBuilder.buildShardingMasterQuery();
        this.slaveQueryer = dataLayerBuilder.buildShardingSlaveQuery();
        instance = this;
    }

    @Override
    public void beginTransaction() {
        this.beginTransaction(EnumTransactionIsolationLevel.READ_COMMITTED);
    }

    @Override
    public void beginTransaction(EnumTransactionIsolationLevel txLevel) {
        ((BestEffortsOnePCJtaTransactionManager)this.txManager).setTransactionIsolationLevel(txLevel);
        try {
            this.txManager.begin();
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void commit() {
        try {
            this.txManager.commit();
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.txManager.rollback();
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public <T> TaskFuture submit(ITask<T> task, Class<T> clazz) {
        TaskExecutor<T> taskExecutor = new TaskExecutor<T>(clazz, this.dbCluster);
        return taskExecutor.execute(task);
    }

    @Override
    public <T> TaskFuture submit(ITask<T> task, Class<T> clazz, IQuery query) {
        TaskExecutor<T> taskExecutor = new TaskExecutor<T>(clazz, this.dbCluster);
        return taskExecutor.execute(task, query);
    }

    @Override
    public Number globalSave(Object entity) {
        CheckUtil.checkGlobalEntity(entity);
        String clusterName = ReflectUtil.getClusterName(entity.getClass());
        CheckUtil.checkClusterName(clusterName);
        return this.globalUpdater.globalSave(entity, clusterName);
    }

    @Override
    public Number[] globalSaveBatch(List<? extends Object> entities, String clusterName) {
        CheckUtil.checkEntityList(entities);
        CheckUtil.checkClusterName(clusterName);
        return this.globalUpdater.globalSaveBatch(entities, clusterName);
    }

    @Override
    public void globalUpdate(Object entity) {
        CheckUtil.checkGlobalEntity(entity);
        String clusterName = ReflectUtil.getClusterName(entity.getClass());
        CheckUtil.checkClusterName(clusterName);
        this.globalUpdater.globalUpdate(entity, clusterName);
    }

    @Override
    public void globalUpdateBatch(List<? extends Object> entities, String clusterName) {
        CheckUtil.checkEntityList(entities);
        CheckUtil.checkClusterName(clusterName);
        this.globalUpdater.globalUpdateBatch(entities, clusterName);
    }

    @Override
    public void globalRemoveByPk(Number pk, Class<?> clazz, String clusterName) {
        CheckUtil.checkNumberGtZero(pk);
        CheckUtil.checkClass(clazz);
        CheckUtil.checkClusterName(clusterName);
        this.globalUpdater.globalRemoveByPk(pk, clazz, clusterName);
    }

    @Override
    public void globalRemoveByPkList(List<? extends Number> pks, Class<?> clazz, String clusterName) {
        if (pks == null || pks.isEmpty()) {
            return;
        }
        CheckUtil.checkClass(clazz);
        CheckUtil.checkClusterName(clusterName);
        this.globalUpdater.globalRemoveByPks(pks, clazz, clusterName);
    }

    @Override
    public void globalRemoveByPks(String clusterName, Class<?> clazz, Number ... pks) {
        if (pks == null || pks.length == 0) {
            return;
        }
        this.globalRemoveByPkList(Arrays.asList(pks), clazz, clusterName);
    }

    @Override
    public Number save(Object entity) {
        CheckUtil.checkShardingEntity(entity);
        String clusterName = ReflectUtil.getClusterName(entity.getClass());
        Object shardingKey = ReflectUtil.getShardingValue(entity);
        ShardingKey<Object> sk = new ShardingKey<Object>(clusterName, shardingKey);
        CheckUtil.checkShardingValue(sk);
        return this.shardingUpdater.save(entity, sk);
    }

    @Override
    public void update(Object entity) {
        CheckUtil.checkShardingEntity(entity);
        String clusterName = ReflectUtil.getClusterName(entity.getClass());
        Object shardingKey = ReflectUtil.getShardingValue(entity);
        ShardingKey<Object> sk = new ShardingKey<Object>(clusterName, shardingKey);
        CheckUtil.checkShardingValue(sk);
        this.shardingUpdater.update(entity, sk);
    }

    @Override
    public Number[] saveBatch(List<? extends Object> entities, IShardingKey<?> shardingKey) {
        CheckUtil.checkEntityList(entities);
        CheckUtil.checkShardingValue(shardingKey);
        return this.shardingUpdater.saveBatch(entities, shardingKey);
    }

    @Override
    public void updateBatch(List<? extends Object> entities, IShardingKey<?> shardingKey) {
        CheckUtil.checkEntityList(entities);
        CheckUtil.checkShardingValue(shardingKey);
        this.shardingUpdater.updateBatch(entities, shardingKey);
    }

    @Override
    public void removeByPk(Number pk, IShardingKey<?> shardingKey, Class<?> clazz) {
        CheckUtil.checkNumberGtZero(pk);
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        this.shardingUpdater.removeByPk(pk, shardingKey, clazz);
    }

    @Override
    public void removeByPkList(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<?> clazz) {
        if (pks == null || pks.isEmpty()) {
            return;
        }
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        this.shardingUpdater.removeByPks(pks, shardingKey, clazz);
    }

    @Override
    public void removeByPks(IShardingKey<?> shardingKey, Class<?> clazz, Number ... pks) {
        if (pks == null || pks.length == 0) {
            return;
        }
        this.removeByPkList(Arrays.asList(pks), shardingKey, clazz);
    }

    @Override
    public Number getGlobalCount(String clusterName, Class<?> clazz) {
        return this.getGlobalCount(clusterName, clazz, true);
    }

    @Override
    public Number getGlobalCount(String clusterName, Class<?> clazz, boolean useCache) {
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        return this.globalMasterQuery.getGlobalCountFromMaster(clusterName, clazz, useCache);
    }

    @Override
    public Number getGlobalCount(String clusterName, Class<?> clazz, EnumDBMasterSlave masterSlave) {
        return this.getGlobalCount(clusterName, clazz, true, masterSlave);
    }

    @Override
    public Number getGlobalCount(String clusterName, Class<?> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        if (masterSlave == null) {
            throw new IllegalArgumentException("master slave param cann't be null");
        }
        switch (masterSlave) {
            case MASTER: {
                return this.globalMasterQuery.getGlobalCountFromMaster(clusterName, clazz, useCache);
            }
        }
        return this.globalSlaveQuery.getGlobalCountFromSlave(clusterName, clazz, useCache, masterSlave);
    }

    @Override
    public Number getGlobalCount(IQuery query, String clusterName, Class<?> clazz) {
        CheckUtil.checkQuery(query);
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        return this.globalMasterQuery.getGlobalCountFromMaster(query, clusterName, clazz);
    }

    @Override
    public Number getGlobalCount(IQuery query, String clusterName, Class<?> clazz, EnumDBMasterSlave masterSlave) {
        return this.getGlobalCount(query, clusterName, clazz, true, masterSlave);
    }

    @Override
    public Number getGlobalCount(IQuery query, String clusterName, Class<?> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkQuery(query);
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        switch (masterSlave) {
            case MASTER: {
                return this.globalMasterQuery.getGlobalCountFromMaster(clusterName, clazz, useCache);
            }
        }
        return this.globalSlaveQuery.getGlobalCountFromSlave(clusterName, clazz, useCache, masterSlave);
    }

    @Override
    public <T> T findGlobalByPk(Number pk, String clusterName, Class<T> clazz) {
        return this.findGlobalByPk(pk, clusterName, clazz, true);
    }

    @Override
    public <T> T findGlobalByPk(Number pk, String clusterName, Class<T> clazz, boolean useCache) {
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkNumberGtZero(pk);
        CheckUtil.checkClass(clazz);
        return this.globalMasterQuery.findGlobalByPkFromMaster(pk, clusterName, clazz, useCache);
    }

    @Override
    public <T> T findGlobalByPk(Number pk, String clusterName, Class<T> clazz, EnumDBMasterSlave masterSlave) {
        return this.findGlobalByPk(pk, clusterName, clazz, true, masterSlave);
    }

    @Override
    public <T> T findGlobalByPk(Number pk, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkNumberGtZero(pk);
        CheckUtil.checkClass(clazz);
        switch (masterSlave) {
            case MASTER: {
                return this.globalMasterQuery.findGlobalByPkFromMaster(pk, clusterName, clazz, useCache);
            }
        }
        return this.globalSlaveQuery.findGlobalByPkFromSlave(pk, clusterName, clazz, useCache, masterSlave);
    }

    @Override
    public <T> T findGlobalOneByQuery(IQuery query, String clusterName, Class<T> clazz) {
        return this.findGlobalOneByQuery(query, clusterName, clazz, true);
    }

    @Override
    public <T> T findGlobalOneByQuery(IQuery query, String clusterName, Class<T> clazz, boolean useCache) {
        return this.globalMasterQuery.findGlobalOneByQueryFromMaster(query, clusterName, clazz, useCache);
    }

    @Override
    public <T> T findGlobalOneByQuery(IQuery query, String clusterName, Class<T> clazz, EnumDBMasterSlave masterSlave) {
        return this.findGlobalOneByQuery(query, clusterName, clazz, true, masterSlave);
    }

    @Override
    public <T> T findGlobalOneByQuery(IQuery query, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        switch (masterSlave) {
            case MASTER: {
                return this.globalMasterQuery.findGlobalOneByQueryFromMaster(query, clusterName, clazz, useCache);
            }
        }
        return this.globalSlaveQuery.findGlobalOneByQueryFromSlave(query, clusterName, clazz, useCache, masterSlave);
    }

    @Override
    public <T> List<T> findGlobalByPks(String clusterName, Class<T> clazz, Number ... pks) {
        if (pks == null || pks.length == 0) {
            return new ArrayList();
        }
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        return this.globalMasterQuery.findGlobalByPksFromMaster(clusterName, clazz, pks);
    }

    @Override
    public <T> List<T> findGlobalByPks(String clusterName, Class<T> clazz, boolean useCache, Number ... pks) {
        if (pks == null || pks.length == 0) {
            return new ArrayList();
        }
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        return this.globalMasterQuery.findGlobalByPksFromMaster(clusterName, clazz, useCache, pks);
    }

    @Override
    public <T> List<T> findGlobalByPks(String clusterName, Class<T> clazz, EnumDBMasterSlave masterSlave, Number ... pks) {
        return this.findGlobalByPks(clusterName, clazz, masterSlave, true, pks);
    }

    @Override
    public <T> List<T> findGlobalByPks(String clusterName, Class<T> clazz, EnumDBMasterSlave masterSlave, boolean useCache, Number ... pks) {
        if (pks == null || pks.length == 0) {
            return new ArrayList();
        }
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        switch (masterSlave) {
            case MASTER: {
                return this.globalMasterQuery.findGlobalByPksFromMaster(clusterName, clazz, useCache, pks);
            }
        }
        return this.globalSlaveQuery.findGlobalByPksFromSlave(clusterName, clazz, masterSlave, useCache, pks);
    }

    @Override
    public <T> List<T> findGlobalByPkList(List<? extends Number> pks, String clusterName, Class<T> clazz) {
        return this.findGlobalByPkList(pks, clusterName, clazz, true);
    }

    @Override
    public <T> List<T> findGlobalByPkList(List<? extends Number> pks, String clusterName, Class<T> clazz, boolean useCache) {
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        CheckUtil.checkNumberList(pks);
        return this.globalMasterQuery.findGlobalByPkListFromMaster(pks, clusterName, clazz, useCache);
    }

    @Override
    public <T> List<T> findGlobalByPkList(List<? extends Number> pks, String clusterName, Class<T> clazz, EnumDBMasterSlave masterSlave) {
        return this.findGlobalByPkList(pks, clusterName, clazz, true, masterSlave);
    }

    @Override
    public <T> List<T> findGlobalByPkList(List<? extends Number> pks, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        CheckUtil.checkNumberList(pks);
        switch (masterSlave) {
            case MASTER: {
                return this.globalMasterQuery.findGlobalByPkListFromMaster(pks, clusterName, clazz, useCache);
            }
        }
        return this.globalSlaveQuery.findGlobalByPkListFromSlave(pks, clusterName, clazz, useCache, masterSlave);
    }

    @Override
    public List<Map<String, Object>> findGlobalBySql(SQL sql, String clusterName) {
        CheckUtil.checkSQL(sql);
        CheckUtil.checkClusterName(clusterName);
        return this.globalMasterQuery.findGlobalBySqlFromMaster(sql, clusterName);
    }

    @Override
    public List<Map<String, Object>> findGlobalBySql(SQL sql, String clusterName, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkSQL(sql);
        CheckUtil.checkClusterName(clusterName);
        switch (masterSlave) {
            case MASTER: {
                return this.globalMasterQuery.findGlobalBySqlFromMaster(sql, clusterName);
            }
        }
        return this.globalSlaveQuery.findGlobalBySqlFromSlave(sql, clusterName, masterSlave);
    }

    @Override
    public <T> List<T> findGlobalByQuery(IQuery query, String clusterName, Class<T> clazz) {
        return this.findGlobalByQuery(query, clusterName, clazz, true);
    }

    @Override
    public <T> List<T> findGlobalByQuery(IQuery query, String clusterName, Class<T> clazz, boolean useCache) {
        CheckUtil.checkQuery(query);
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        return this.globalMasterQuery.findGlobalByQueryFromMaster(query, clusterName, clazz, useCache);
    }

    @Override
    public <T> List<T> findGlobalByQuery(IQuery query, String clusterName, Class<T> clazz, EnumDBMasterSlave masterSlave) {
        return this.findGlobalByQuery(query, clusterName, clazz, true, masterSlave);
    }

    @Override
    public <T> List<T> findGlobalByQuery(IQuery query, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkQuery(query);
        CheckUtil.checkClusterName(clusterName);
        CheckUtil.checkClass(clazz);
        switch (masterSlave) {
            case MASTER: {
                return this.globalMasterQuery.findGlobalByQueryFromMaster(query, clusterName, clazz, useCache);
            }
        }
        return this.globalSlaveQuery.findGlobalByQueryFromSlave(query, clusterName, clazz, useCache, masterSlave);
    }

    @Override
    public Number getCount(Class<?> clazz) {
        return this.getCount(clazz, true);
    }

    @Override
    public Number getCount(Class<?> clazz, boolean useCache) {
        CheckUtil.checkClass(clazz);
        return this.masterQueryer.getCountFromMaster(clazz, useCache);
    }

    @Override
    public Number getCount(Class<?> clazz, IQuery query) {
        CheckUtil.checkClass(clazz);
        CheckUtil.checkQuery(query);
        return this.masterQueryer.getCountFromMaster(clazz, query);
    }

    @Override
    public Number getCount(IShardingKey<?> shardingKey, Class<?> clazz) {
        return this.getCount(shardingKey, clazz, true);
    }

    @Override
    public Number getCount(IShardingKey<?> shardingKey, Class<?> clazz, boolean useCache) {
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        return this.masterQueryer.getCountFromMaster(shardingKey, clazz, useCache);
    }

    @Override
    public Number getCount(IQuery query, IShardingKey<?> shardingKey, Class<?> clazz) {
        CheckUtil.checkQuery(query);
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        return this.masterQueryer.getCountFromMaster(query, shardingKey, clazz);
    }

    @Override
    public <T> T findByPk(Number pk, IShardingKey<?> shardingKey, Class<T> clazz) {
        return this.findByPk(pk, shardingKey, clazz, true);
    }

    @Override
    public <T> T findByPk(Number pk, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        CheckUtil.checkNumberGtZero(pk);
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        return this.masterQueryer.findByPkFromMaster(pk, shardingKey, clazz, useCache);
    }

    @Override
    public <T> T findByPk(Number pk, IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave masterSlave) {
        return this.findByPk(pk, shardingKey, clazz, true, masterSlave);
    }

    @Override
    public <T> T findByPk(Number pk, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkNumberGtZero(pk);
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        switch (masterSlave) {
            case MASTER: {
                return this.masterQueryer.findByPkFromMaster(pk, shardingKey, clazz, useCache);
            }
        }
        return this.slaveQueryer.findByPkFromSlave(pk, shardingKey, clazz, useCache, masterSlave);
    }

    @Override
    public <T> T findOneByQuery(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz) {
        return this.findOneByQuery(query, shardingKey, clazz, true);
    }

    @Override
    public <T> T findOneByQuery(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        return this.masterQueryer.findOneByQueryFromMaster(query, shardingKey, clazz, useCache);
    }

    @Override
    public <T> T findOneByQuery(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave masterSlave) {
        return this.findOneByQuery(query, shardingKey, clazz, true, masterSlave);
    }

    @Override
    public <T> T findOneByQuery(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        switch (masterSlave) {
            case MASTER: {
                return this.masterQueryer.findOneByQueryFromMaster(query, shardingKey, clazz, useCache);
            }
        }
        return this.slaveQueryer.findOneByQueryFromSlave(query, shardingKey, clazz, useCache, masterSlave);
    }

    @Override
    public <T> List<T> findByPks(IShardingKey<?> shardingKey, Class<T> clazz, Number ... pks) {
        return this.findByPks(shardingKey, clazz, true, pks);
    }

    @Override
    public <T> List<T> findByPks(IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, Number ... pks) {
        if (pks == null || pks.length == 0) {
            return new ArrayList();
        }
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        return this.masterQueryer.findByPksFromMaster(shardingKey, clazz, useCache, pks);
    }

    @Override
    public <T> List<T> findByPks(IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave masterSlave, Number ... pks) {
        return this.findByPks(shardingKey, clazz, masterSlave, true, pks);
    }

    @Override
    public <T> List<T> findByPks(IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave masterSlave, boolean useCache, Number ... pks) {
        if (pks == null || pks.length == 0) {
            return new ArrayList();
        }
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        switch (masterSlave) {
            case MASTER: {
                return this.masterQueryer.findByPksFromMaster(shardingKey, clazz, useCache, pks);
            }
        }
        return this.slaveQueryer.findByPksFromSlave(shardingKey, clazz, masterSlave, useCache, pks);
    }

    @Override
    public <T> List<T> findByPkList(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<T> clazz) {
        return this.findByPkList(pks, shardingKey, clazz, true);
    }

    @Override
    public <T> List<T> findByPkList(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        CheckUtil.checkNumberList(pks);
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        return this.masterQueryer.findByPkListFromMaster(pks, shardingKey, clazz, useCache);
    }

    @Override
    public <T> List<T> findByPkList(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave masterSlave) {
        return this.findByPkList(pks, shardingKey, clazz, true, masterSlave);
    }

    @Override
    public <T> List<T> findByPkList(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkNumberList(pks);
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        switch (masterSlave) {
            case MASTER: {
                return this.masterQueryer.findByPkListFromMaster(pks, shardingKey, clazz, useCache);
            }
        }
        return this.slaveQueryer.findByPkListFromSlave(pks, shardingKey, clazz, useCache, masterSlave);
    }

    @Override
    public List<Map<String, Object>> findBySql(SQL sql, IShardingKey<?> shardingKey) {
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkSQL(sql);
        return this.masterQueryer.findBySqlFromMaster(sql, shardingKey);
    }

    @Override
    public List<Map<String, Object>> findBySql(SQL sql, IShardingKey<?> shardingKey, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkSQL(sql);
        switch (masterSlave) {
            case MASTER: {
                return this.masterQueryer.findBySqlFromMaster(sql, shardingKey);
            }
        }
        return this.slaveQueryer.findBySqlFromSlave(sql, shardingKey, masterSlave);
    }

    @Override
    public <T> List<T> findByQuery(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz) {
        return this.findByQuery(query, shardingKey, clazz, true);
    }

    @Override
    public <T> List<T> findByQuery(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        CheckUtil.checkQuery(query);
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        return this.masterQueryer.findByQueryFromMaster(query, shardingKey, clazz, useCache);
    }

    @Override
    public <T> List<T> findByQuery(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave masterSlave) {
        return this.findByQuery(query, shardingKey, clazz, true, masterSlave);
    }

    @Override
    public <T> List<T> findByQuery(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        CheckUtil.checkQuery(query);
        CheckUtil.checkShardingValue(shardingKey);
        CheckUtil.checkClass(clazz);
        switch (masterSlave) {
            case MASTER: {
                return this.masterQueryer.findByQueryFromMaster(query, shardingKey, clazz, useCache);
            }
        }
        return this.slaveQueryer.findByQueryFromSlave(query, shardingKey, clazz, useCache, masterSlave);
    }

    @Override
    public IDBCluster getDBCluster() {
        return this.dbCluster;
    }

    @Override
    public int genClusterUniqueIntId(String name) {
        return this.idGenerator.genClusterUniqueIntId("/pinus/sequence", name);
    }

    @Override
    public long genClusterUniqueLongId(String name) {
        return this.idGenerator.genClusterUniqueLongId("/pinus/sequence", name);
    }

    @Override
    public long[] genClusterUniqueLongIdBatch(String name, int batchSize) {
        return this.idGenerator.genClusterUniqueLongIdBatch("/pinus/sequence", name, batchSize);
    }

    @Override
    public int[] genClusterUniqueIntIdBatch(String name, int batchSize) {
        return this.idGenerator.genClusterUniqueIntIdBatch("/pinus/sequence", name, batchSize);
    }

    @Override
    public IIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public Lock createLock(String lockName) {
        return this.dbCluster.createLock(lockName);
    }

    @Override
    public void setIdGenerator(IIdGenerator idGenerator) {
        if (idGenerator == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.idGenerator = idGenerator;
    }

    @Override
    public IQuery createQuery() {
        QueryImpl query = new QueryImpl();
        return query;
    }

    public EnumDB getEnumDb() {
        return this.enumDb;
    }

    @Override
    public void setEnumDb(EnumDB enumDb) {
        if (enumDb == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.enumDb = enumDb;
    }

    @Override
    public void destroy() {
        try {
            this.dbCluster.shutdown();
        }
        catch (DBClusterException e) {
            throw new RuntimeException(e);
        }
    }

    public EnumSyncAction getSyncAction() {
        return this.syncAction;
    }

    @Override
    public void setSyncAction(EnumSyncAction syncAction) {
        this.syncAction = syncAction;
    }

    public String getScanPackage() {
        return this.scanPackage;
    }

    @Override
    public void setScanPackage(String scanPackage) {
        if (StringUtils.isBlank(scanPackage)) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scanPackage = scanPackage;
    }
}

