/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.transaction.TransactionManager;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.enums.EnumSyncAction;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.ITableCluster;
import org.pinus4j.cluster.beans.DBClusterInfo;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.datalayer.IDataLayerBuilder;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.generator.IIdGenerator;
import org.pinus4j.generator.beans.DBTable;

public interface IDBCluster {
    public TransactionManager getTransactionManager();

    public IPrimaryCache getPrimaryCache();

    public ISecondCache getSecondCache();

    public Lock createLock(String var1);

    public IDataLayerBuilder getDataLayerBuilder();

    public void setShardInfoFromZk(boolean var1);

    public List<DBTable> getDBTableFromZk();

    public List<DBTable> getDBTableFromJvm();

    public Collection<DBClusterInfo> getDBClusterInfo();

    public DBClusterInfo getDBClusterInfo(String var1);

    public void startup() throws DBClusterException;

    public void startup(String var1) throws DBClusterException;

    public void shutdown() throws DBClusterException;

    public IDBResource getMasterGlobalDBResource(String var1, String var2) throws DBClusterException;

    public IDBResource getSlaveGlobalDBResource(String var1, String var2, EnumDBMasterSlave var3) throws DBClusterException;

    public IDBResource selectDBResourceFromMaster(String var1, IShardingKey<?> var2) throws DBClusterException;

    public IDBResource selectDBResourceFromSlave(String var1, IShardingKey<?> var2, EnumDBMasterSlave var3) throws DBClusterException;

    public List<IDBResource> getAllMasterShardingDBResource(Class<?> var1) throws SQLException;

    public List<IDBResource> getAllMasterShardingDBResource(int var1, String var2, String var3) throws SQLException;

    public List<IDBResource> getAllSlaveShardingDBResource(Class<?> var1, EnumDBMasterSlave var2) throws SQLException;

    public void setSyncAction(EnumSyncAction var1);

    public IIdGenerator getIdGenerator();

    public void setScanPackage(String var1);

    public ITableCluster getTableCluster();
}

