/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.beans;

import java.util.Map;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.exceptions.LoadConfigException;
import org.pinus4j.utils.StringUtils;

public class AppDBInfo
extends DBInfo {
    private String username;
    private String password;
    private String url;
    private Map<String, Object> connPoolInfo;

    @Override
    public boolean check() throws LoadConfigException {
        if (StringUtils.isBlank(this.username)) {
            throw new LoadConfigException("db username is empty");
        }
        if (StringUtils.isBlank(this.password)) {
            throw new LoadConfigException("db password is empty");
        }
        if (StringUtils.isBlank(this.url)) {
            throw new LoadConfigException("db url is empty");
        }
        return true;
    }

    public String toString() {
        return "AppDBConnectionInfo [username=" + this.username + ", clusterName=" + this.clusterName + ", masterSlave=" + (Object)((Object)this.masterSlave) + ", url=" + this.url + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connPoolInfo == null ? 0 : this.connPoolInfo.hashCode());
        result = 31 * result + (this.masterSlave == null ? 0 : this.masterSlave.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppDBInfo other = (AppDBInfo)obj;
        if (this.connPoolInfo == null ? other.connPoolInfo != null : !this.connPoolInfo.equals(other.connPoolInfo)) {
            return false;
        }
        if (this.masterSlave != other.masterSlave) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public EnumDBMasterSlave getMasterSlave() {
        return this.masterSlave;
    }

    @Override
    public void setMasterSlave(EnumDBMasterSlave masterSlave) {
        this.masterSlave = masterSlave;
    }

    public void setConnPoolInfo(Map<String, Object> connPoolInfo) {
        this.connPoolInfo = connPoolInfo;
    }

    public Map<String, Object> getConnPoolInfo() {
        return this.connPoolInfo;
    }
}

